/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;

public class HandlerCapability
implements IContainerHandler {
    @Override
    public boolean matches(PlayerEntity player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    @Override
    public int countItems(PlayerEntity player, ItemStack itemStack, ItemStack inventoryStack) {
        Optional itemHandlerOptional = inventoryStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (!itemHandlerOptional.isPresent()) {
            return 0;
        }
        int total = 0;
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack containerStack = itemHandler.getStackInSlot(i);
            if (!WandUtil.stackEquals(itemStack, containerStack)) continue;
            total += Math.max(0, containerStack.func_190916_E());
        }
        return total;
    }

    @Override
    public int useItems(PlayerEntity player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        ItemStack extracted;
        ItemStack handlerStack;
        Optional itemHandlerOptional = inventoryStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (!itemHandlerOptional.isPresent()) {
            return 0;
        }
        IItemHandler itemHandler = (IItemHandler)itemHandlerOptional.get();
        for (int i = 0; !(i >= itemHandler.getSlots() || WandUtil.stackEquals(itemStack, handlerStack = itemHandler.getStackInSlot(i)) && (count -= (extracted = itemHandler.extractItem(i, count, false)).func_190916_E()) <= 0); ++i) {
        }
        return count;
    }
}

