/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.network.PacketWandOption;

public class ScreenWand
extends Screen {
    private final ItemStack wand;
    private final WandOptions wandOptions;
    private static final int BUTTON_WIDTH = 160;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SPACING_WIDTH = 50;
    private static final int SPACING_HEIGHT = 30;
    private static final int N_COLS = 2;
    private static final int N_ROWS = 3;
    private static final int FIELD_WIDTH = 370;
    private static final int FIELD_HEIGHT = 120;

    public ScreenWand(ItemStack wand) {
        super((ITextComponent)new StringTextComponent("ScreenWand"));
        this.wand = wand;
        this.wandOptions = new WandOptions(wand);
    }

    public void func_231158_b_(@Nonnull Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        this.createButton(0, 0, this.wandOptions.cores);
        this.createButton(0, 1, this.wandOptions.lock);
        this.createButton(0, 2, this.wandOptions.direction);
        this.createButton(1, 0, this.wandOptions.replace);
        this.createButton(1, 1, this.wandOptions.match);
        this.createButton(1, 2, this.wandOptions.random);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ScreenWand.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.wand.func_200301_q(), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 60 - 30), (int)0xFFFFFF);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            this.func_231175_as__();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    private void createButton(int cx, int cy, IOption<?> option) {
        Button button = new Button(this.getX(cx), this.getY(cy), 160, 20, this.getButtonLabel(option), bt -> this.clickButton(bt, option), (bt, ms, x, y) -> this.drawTooltip(ms, x, y, option));
        button.field_230693_o_ = option.isEnabled();
        this.func_230480_a_((Widget)button);
    }

    private void clickButton(Button button, IOption<?> option) {
        option.next();
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(option, false));
        button.func_238482_a_(this.getButtonLabel(option));
    }

    private void drawTooltip(MatrixStack matrixStack, int mouseX, int mouseY, IOption<?> option) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent(option.getDescTranslation()), mouseX, mouseY);
        }
    }

    private int getX(int n) {
        return this.field_230708_k_ / 2 - 185 + n * 210;
    }

    private int getY(int n) {
        return this.field_230709_l_ / 2 - 60 + n * 50;
    }

    private ITextComponent getButtonLabel(IOption<?> option) {
        return new TranslationTextComponent(option.getKeyTranslation()).func_230529_a_((ITextComponent)new TranslationTextComponent(option.getValueTranslation()));
    }
}

