/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigClient;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.client.ScreenWand;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.network.PacketQueryUndo;
import thetadev.constructionwand.network.PacketWandOption;

public class ClientEvents {
    private boolean optPressed = false;

    @SubscribeEvent
    public void KeyEvent(InputEvent.KeyInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (WandUtil.holdingWand((PlayerEntity)player) == null) {
            return;
        }
        boolean optState = ClientEvents.isOptKeyDown();
        if (this.optPressed != optState) {
            this.optPressed = optState;
            PacketQueryUndo packet = new PacketQueryUndo(this.optPressed);
            ConstructionWand.instance.HANDLER.sendToServer((Object)packet);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void MouseScrollEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        double scroll = event.getScrollDelta();
        if (player == null || !ClientEvents.modeKeyCombDown((PlayerEntity)player) || scroll == 0.0) {
            return;
        }
        ItemStack wand = WandUtil.holdingWand((PlayerEntity)player);
        if (wand == null) {
            return;
        }
        WandOptions wandOptions = new WandOptions(wand);
        wandOptions.lock.next(scroll < 0.0);
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(wandOptions.lock, true));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        PlayerEntity player = event.getPlayer();
        if (player == null || !ClientEvents.modeKeyCombDown(player)) {
            return;
        }
        ItemStack wand = event.getItemStack();
        if (!(wand.func_77973_b() instanceof ItemWand)) {
            return;
        }
        WandOptions wandOptions = new WandOptions(wand);
        wandOptions.cores.next();
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(wandOptions.cores, true));
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        if (player == null || !ClientEvents.guiKeyCombDown(player)) {
            return;
        }
        ItemStack wand = event.getItemStack();
        if (!(wand.func_77973_b() instanceof ItemWand)) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a((Screen)new ScreenWand(wand));
        event.setCanceled(true);
    }

    private static boolean isKeyDown(int id) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)id);
    }

    public static boolean isOptKeyDown() {
        return ClientEvents.isKeyDown((Integer)ConfigClient.OPT_KEY.get());
    }

    public static boolean modeKeyCombDown(PlayerEntity player) {
        return player.func_225608_bj_() && (ClientEvents.isOptKeyDown() || (Boolean)ConfigClient.SHIFTOPT_MODE.get() == false);
    }

    public static boolean guiKeyCombDown(PlayerEntity player) {
        return player.func_225608_bj_() && (ClientEvents.isOptKeyDown() || (Boolean)ConfigClient.SHIFTOPT_GUI.get() == false);
    }
}

