/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.entity;

import com.lilypuree.connectiblechains.entity.ChainCollisionEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import com.lilypuree.connectiblechains.network.ModPacketHandler;
import com.lilypuree.connectiblechains.network.S2CChainAttachPacket;
import com.lilypuree.connectiblechains.network.S2CChainDetachPacket;
import com.lilypuree.connectiblechains.util.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class ChainKnotEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private static final double MAX_RANGE = 7.0;
    public static final double VISIBLE_RANGE = 2048.0;
    private final Map<Integer, ArrayList<Integer>> COLLISION_STORAGE;
    private final Map<Integer, Entity> holdingEntities = new HashMap<Integer, Entity>();
    private int holdersCount = 0;
    private ListNBT chainTags;
    private int obstructionCheckCounter;

    public ChainKnotEntity(EntityType<? extends ChainKnotEntity> entityType, World world) {
        super(entityType, world);
        this.COLLISION_STORAGE = new HashMap<Integer, ArrayList<Integer>>();
    }

    public ChainKnotEntity(World world, BlockPos pos) {
        super((EntityType)ModEntityTypes.CHAIN_KNOT.get(), world, pos);
        this.func_242281_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - 0.1875, this.func_226278_cu_() - 0.25 + 0.125, this.func_226281_cx_() - 0.1875, this.func_226277_ct_() + 0.1875, this.func_226278_cu_() + 0.25 + 0.125, this.func_226281_cx_() + 0.1875));
        this.field_98038_p = true;
        this.COLLISION_STORAGE = new HashMap<Integer, ArrayList<Integer>>();
    }

    public static Boolean tryAttachHeldChainsToBlock(PlayerEntity playerEntity, World world, BlockPos pos, @Nullable ChainKnotEntity chain) {
        boolean hasMadeConnection = false;
        double i = pos.func_177958_n();
        double j = pos.func_177956_o();
        double k = pos.func_177952_p();
        List list = world.func_217357_a(ChainKnotEntity.class, new AxisAlignedBB(i - 7.0, j - 7.0, k - 7.0, i + 7.0, j + 7.0, k + 7.0));
        for (ChainKnotEntity otherKnots : list) {
            if (!otherKnots.getHoldingEntities().contains(playerEntity) || otherKnots.equals((Object)chain)) continue;
            if (chain == null) {
                chain = new ChainKnotEntity(world, pos);
                world.func_217376_c((Entity)chain);
                chain.func_184523_o();
            }
            otherKnots.attachChain((Entity)chain, true, playerEntity.func_145782_y());
            hasMadeConnection = true;
        }
        return hasMadeConnection;
    }

    protected void func_174859_a(Direction facing) {
    }

    protected void func_174856_o() {
        this.func_226288_n_((double)this.field_174861_a.func_177958_n() + 0.5, (double)this.field_174861_a.func_177956_o() + 0.5, (double)this.field_174861_a.func_177952_p() + 0.5);
        this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - 0.1875, this.func_226278_cu_() - 0.25 + 0.125, this.func_226281_cx_() - 0.1875, this.func_226277_ct_() + 0.1875, this.func_226278_cu_() + 0.25 + 0.125, this.func_226281_cx_() + 0.1875));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_226278_cu_() < -64.0) {
                this.func_70106_y();
            }
            this.updateChains();
            if (this.obstructionCheckCounter++ == 100) {
                this.obstructionCheckCounter = 0;
                if (!this.field_70128_L && !this.canStayAttached()) {
                    ArrayList<Entity> list = this.getHoldingEntities();
                    for (Entity entity : list) {
                        if (!(entity instanceof ChainKnotEntity)) continue;
                        this.damageLink(false, (ChainKnotEntity)entity);
                    }
                    this.func_70106_y();
                    this.func_110128_b(null);
                }
            }
        }
    }

    public boolean canStayAttached() {
        Block block = this.field_70170_p.func_180495_p(this.field_174861_a).func_177230_c();
        return ChainKnotEntity.canConnectTo(block);
    }

    public static boolean canConnectTo(Block block) {
        return block.func_203417_a((ITag)BlockTags.field_219757_z) || block.func_203417_a((ITag)BlockTags.field_219748_G);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            Entity sourceEntity = source.func_76346_g();
            if (sourceEntity instanceof PlayerEntity) {
                boolean isCreative = ((PlayerEntity)sourceEntity).func_184812_l_();
                if (!((PlayerEntity)sourceEntity).func_184614_ca().func_190926_b() && ((PlayerEntity)sourceEntity).func_184614_ca().func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
                    this.breakChain(isCreative);
                }
            }
            return true;
        }
        return true;
    }

    public void breakChain(boolean doNotDrop) {
        ArrayList<Entity> list = this.getHoldingEntities();
        for (Entity entity : list) {
            if (!(entity instanceof ChainKnotEntity)) continue;
            this.damageLink(doNotDrop, (ChainKnotEntity)entity);
        }
        double i = this.field_174861_a.func_177958_n();
        double j = this.field_174861_a.func_177956_o();
        double k = this.field_174861_a.func_177952_p();
        List chainList = this.field_70170_p.func_217357_a(ChainKnotEntity.class, new AxisAlignedBB(i - 7.0, j - 7.0, k - 7.0, i + 7.0, j + 7.0, k + 7.0));
        for (ChainKnotEntity otherKnots : chainList) {
            if (!otherKnots.getHoldingEntities().contains((Object)this)) continue;
            otherKnots.damageLink(doNotDrop, this);
        }
        this.func_110128_b(null);
        this.func_70106_y();
    }

    public void func_213281_b(CompoundNBT tag) {
        boolean b = false;
        ListNBT listTag = new ListNBT();
        for (Entity entity : this.holdingEntities.values()) {
            if (entity == null) continue;
            CompoundNBT compoundTag = new CompoundNBT();
            if (entity instanceof PlayerEntity) {
                UUID uuid = entity.func_110124_au();
                compoundTag.func_186854_a("UUID", uuid);
                b = true;
            } else if (entity instanceof HangingEntity) {
                BlockPos blockPos = ((HangingEntity)entity).func_174857_n();
                compoundTag.func_74768_a("X", blockPos.func_177958_n());
                compoundTag.func_74768_a("Y", blockPos.func_177956_o());
                compoundTag.func_74768_a("Z", blockPos.func_177952_p());
                b = true;
            }
            listTag.add((Object)compoundTag);
        }
        if (b) {
            tag.func_218657_a("Chains", (INBT)listTag);
        } else if (this.chainTags != null && !this.chainTags.isEmpty()) {
            tag.func_218657_a("Chains", (INBT)this.chainTags.func_74737_b());
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        if (tag.func_74764_b("Chains")) {
            this.chainTags = tag.func_150295_c("Chains", 10);
        }
    }

    public int func_82329_d() {
        return 9;
    }

    public int func_82330_g() {
        return 9;
    }

    public void func_110128_b(@Nullable Entity entity) {
        this.func_184185_a(SoundEvents.field_232697_bz_, 1.0f, 1.0f);
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_232695_bC_, 1.0f, 1.0f);
    }

    public void func_242281_f(double x, double y, double z) {
        super.func_242281_f((double)MathHelper.func_76128_c((double)x) + 0.5, (double)MathHelper.func_76128_c((double)y) + 0.5, (double)MathHelper.func_76128_c((double)z) + 0.5);
    }

    protected void updateChains() {
        Entity[] entitySet;
        if (this.chainTags != null) {
            ListNBT copy = this.chainTags.func_74737_b();
            for (INBT tag : copy) {
                assert (tag instanceof CompoundNBT);
                this.deserializeChainTag((CompoundNBT)tag);
            }
        }
        for (Entity entity : entitySet = (Entity[])this.holdingEntities.values().toArray(new Entity[0]).clone()) {
            if (entity == null || this.func_70089_S() && entity.func_70089_S() && !(entity.func_213303_ch().func_72436_e(this.func_213303_ch()) > 49.0)) continue;
            this.detachChain(entity, true, !(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_());
            this.func_110128_b(null);
        }
    }

    public ArrayList<Entity> getHoldingEntities() {
        if (this.field_70170_p.field_72995_K) {
            for (Integer id : this.holdingEntities.keySet()) {
                if (id == 0 || this.holdingEntities.get(id) != null) continue;
                this.holdingEntities.put(id, this.field_70170_p.func_73045_a(id.intValue()));
            }
        }
        return new ArrayList<Entity>(this.holdingEntities.values());
    }

    public void damageLink(boolean doNotDrop, ChainKnotEntity endChain) {
        if (!this.getHoldingEntities().contains((Object)endChain)) {
            return;
        }
        if (endChain.holdersCount <= 1 && endChain.getHoldingEntities().isEmpty()) {
            endChain.func_70106_y();
        }
        this.deleteCollision((Entity)endChain);
        this.detachChain((Entity)endChain, true, !doNotDrop);
        this.func_110128_b(null);
    }

    private void deserializeChainTag(CompoundNBT tag) {
        if (tag != null && this.field_70170_p instanceof ServerWorld) {
            if (tag.func_74764_b("UUID")) {
                UUID uuid = tag.func_186857_a("UUID");
                Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid);
                if (entity != null) {
                    this.attachChain(entity, true, 0);
                    this.chainTags.remove((Object)tag);
                    return;
                }
            } else if (tag.func_74764_b("X")) {
                BlockPos blockPos = new BlockPos(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
                ChainKnotEntity entity = ChainKnotEntity.getOrCreate(this.field_70170_p, blockPos, true);
                if (entity != null) {
                    this.attachChain((Entity)ChainKnotEntity.getOrCreate(this.field_70170_p, blockPos, false), true, 0);
                    this.chainTags.remove((Object)tag);
                }
                return;
            }
            if (this.field_70173_aa > 100) {
                this.func_199703_a((IItemProvider)Items.field_234729_dO_);
                this.chainTags.remove((Object)tag);
            }
        }
    }

    public void attachChain(Entity entity, boolean sendPacket, int fromPlayerEntityId) {
        this.holdingEntities.put(entity.func_145782_y(), entity);
        this.field_98038_p = true;
        if (!(entity instanceof PlayerEntity)) {
            entity.field_98038_p = true;
        }
        if (fromPlayerEntityId != 0) {
            this.removePlayerWithId(fromPlayerEntityId);
        }
        if (!this.field_70170_p.field_72995_K && sendPacket && this.field_70170_p instanceof ServerWorld) {
            if (entity instanceof ChainKnotEntity) {
                ++((ChainKnotEntity)entity).holdersCount;
                this.createCollision(entity);
            }
            this.sendAttachChainPacket(entity.func_145782_y(), fromPlayerEntityId);
        }
    }

    public void detachChain(Entity entity, boolean sendPacket, boolean dropItem) {
        if (entity != null) {
            if (this.holdingEntities.size() <= 1) {
                this.field_98038_p = false;
            }
            if (entity instanceof ChainKnotEntity && ((ChainKnotEntity)entity).holdingEntities.isEmpty()) {
                entity.field_98038_p = false;
            }
            this.holdingEntities.remove(entity.func_145782_y());
            if (!this.field_70170_p.field_72995_K && dropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                Vector3d middle = Helper.middleOf(this.func_213303_ch(), entity.func_213303_ch());
                ItemEntity entity1 = new ItemEntity(this.field_70170_p, middle.field_72450_a, middle.field_72448_b, middle.field_72449_c, new ItemStack((IItemProvider)Items.field_234729_dO_));
                entity1.func_174869_p();
                this.field_70170_p.func_217376_c((Entity)entity1);
            }
            if (!this.field_70170_p.field_72995_K && sendPacket && this.field_70170_p instanceof ServerWorld) {
                if (entity instanceof ChainKnotEntity) {
                    --((ChainKnotEntity)entity).holdersCount;
                    if (this.holdersCount <= 0 && this.getHoldingEntities().isEmpty()) {
                        this.func_70106_y();
                    }
                }
                this.deleteCollision(entity);
                this.sendDetachChainPacket(entity.func_145782_y());
            }
        }
    }

    private void createCollision(Entity entity) {
        double a;
        double distance = this.func_174857_n().func_218139_n((Vector3i)entity.func_233580_cy_());
        ArrayList<Integer> entityIdList = new ArrayList<Integer>();
        double offset = 0.2;
        for (double v = a = 0.5 / distance; v <= 1.0 - a / 2.0; v += a) {
            double z;
            double y;
            double x = MathHelper.func_219803_d((double)v, (double)this.func_226277_ct_(), (double)entity.func_226277_ct_());
            ChainCollisionEntity c = new ChainCollisionEntity(this.field_70170_p, x - 0.15, y = MathHelper.func_219803_d((double)v, (double)this.func_226278_cu_(), (double)entity.func_226278_cu_()) + Helper.drip(v * distance, distance) + offset, (z = MathHelper.func_219803_d((double)v, (double)this.func_226281_cx_(), (double)entity.func_226281_cx_())) - 0.15, this.func_145782_y(), entity.func_145782_y());
            if (this.field_70170_p.func_217376_c((Entity)c)) {
                entityIdList.add(c.func_145782_y());
                continue;
            }
            field_184243_a.warn("Tried to summon collision entity for a chain, failed to do so");
        }
        this.COLLISION_STORAGE.put(entity.func_145782_y(), entityIdList);
    }

    private void deleteCollision(Entity entity) {
        int entityId = entity.func_145782_y();
        ArrayList<Integer> entityIdList = this.COLLISION_STORAGE.get(entityId);
        if (entityIdList != null) {
            entityIdList.forEach(id -> {
                Entity e = this.field_70170_p.func_73045_a(id.intValue());
                if (e instanceof ChainCollisionEntity) {
                    e.func_70106_y();
                }
            });
        }
        this.COLLISION_STORAGE.remove(entityId);
    }

    @Nullable
    public static ChainKnotEntity getOrCreate(World world, BlockPos pos, Boolean hasToExist) {
        ChainKnotEntity surroundingChains;
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        List list = world.func_217357_a(ChainKnotEntity.class, new AxisAlignedBB((double)posX - 1.0, (double)posY - 1.0, (double)posZ - 1.0, (double)posX + 1.0, (double)posY + 1.0, (double)posZ + 1.0));
        Iterator var6 = list.iterator();
        do {
            if (var6.hasNext()) continue;
            if (hasToExist.booleanValue()) {
                return null;
            }
            ChainKnotEntity newChain = new ChainKnotEntity(world, pos);
            world.func_217376_c((Entity)newChain);
            newChain.func_184523_o();
            return newChain;
        } while ((surroundingChains = (ChainKnotEntity)((Object)var6.next())) == null || !surroundingChains.func_174857_n().equals((Object)pos));
        return surroundingChains;
    }

    public void sendAttachChainPacket(int entityId, int fromPlayerEntityId) {
        Stream<ServerPlayerEntity> watchingPlayers = ChainKnotEntity.around((ServerWorld)this.field_70170_p, (Vector3i)this.func_233580_cy_(), 2048.0).stream();
        S2CChainAttachPacket packet = new S2CChainAttachPacket(new int[]{this.func_145782_y(), entityId}, fromPlayerEntityId);
        watchingPlayers.forEach(playerEntity -> ModPacketHandler.sendToClient(packet, playerEntity));
    }

    private void sendDetachChainPacket(int entityId) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Stream<ServerPlayerEntity> watchingPlayers = ChainKnotEntity.around((ServerWorld)this.field_70170_p, (Vector3i)this.func_233580_cy_(), 2048.0).stream();
        S2CChainDetachPacket packet = new S2CChainDetachPacket(new int[]{this.func_145782_y(), entityId});
        watchingPlayers.forEach(playerEntity -> ModPacketHandler.sendToClient(packet, playerEntity));
    }

    private void removePlayerWithId(int playerId) {
        this.holdingEntities.remove(playerId);
    }

    public boolean func_70112_a(double distance) {
        return distance < 2048.0;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.field_70170_p.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        boolean madeConnection = ChainKnotEntity.tryAttachHeldChainsToBlock(player, this.field_70170_p, this.func_174857_n(), this);
        if (!madeConnection) {
            if (this.getHoldingEntities().contains(player)) {
                this.func_110128_b(null);
                this.detachChain((Entity)player, true, false);
                if (!player.func_184812_l_()) {
                    player.func_191521_c(new ItemStack((IItemProvider)Items.field_234729_dO_));
                }
            } else if (player.func_184586_b(hand).func_77973_b().equals(Items.field_234729_dO_)) {
                this.func_184523_o();
                this.attachChain((Entity)player, true, 0);
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
            } else {
                this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 0.0f);
            }
        } else {
            this.func_184523_o();
        }
        return ActionResultType.CONSUME;
    }

    protected float func_213316_a(Pose pose, EntitySize dimensions) {
        return -0.0625f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Vector3d func_241843_o(float f) {
        return super.func_241843_o(f).func_72441_c(0.0, 0.2, 0.0);
    }

    public void addHoldingEntityId(int id, int fromPlayerId) {
        if (fromPlayerId != 0) {
            this.holdingEntities.remove(fromPlayerId);
        }
        this.holdingEntities.put(id, null);
    }

    public void removeHoldingEntityId(int id) {
        this.holdingEntities.remove(id);
    }

    public void addHoldingEntityIds(int[] ids) {
        for (int id : ids) {
            this.holdingEntities.put(id, null);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
    }

    public void readSpawnData(PacketBuffer additionalData) {
        Vector3d pos = this.func_213303_ch();
        this.func_174826_a(new AxisAlignedBB(pos.func_82615_a() - 0.1875, pos.func_82617_b() - 0.25 + 0.125, pos.func_82616_c() - 0.1875, pos.func_82615_a() + 0.1875, pos.func_82617_b() + 0.25 + 0.125, pos.func_82616_c() + 0.1875));
        this.field_98038_p = true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_234729_dO_);
    }

    public static Collection<ServerPlayerEntity> around(ServerWorld world, Vector3i pos, double radius) {
        double radiusSq = radius * radius;
        return ChainKnotEntity.world(world).stream().filter(p -> p.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= radiusSq).collect(Collectors.toList());
    }

    public static Collection<ServerPlayerEntity> world(ServerWorld world) {
        Objects.requireNonNull(world, "The world cannot be null");
        return Collections.unmodifiableCollection(world.func_217369_A());
    }
}

