/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurableextramobdrops.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective.functions.StringFunctions;
import com.natamus.configurableextramobdrops.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;

public class CommandCemd {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"cemd").requires(iCommandSender -> iCommandSender.func_197034_c(2))).executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        })).then(Commands.func_197057_a((String)"usage").executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            CommandCemd.showUsage(source);
            return 1;
        }))).then(Commands.func_197057_a((String)"list").executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            ArrayList<String> mobnames = new ArrayList<String>();
            for (EntityType<?> et : Util.mobdrops.keySet()) {
                String lowerregister = et.getRegistryName().toString().toLowerCase();
                String[] nspl = lowerregister.split(":");
                if (nspl.length < 2) continue;
                String after = nspl[1];
                if (!nspl[0].equalsIgnoreCase("minecraft")) {
                    after = lowerregister.replace(":", "-");
                }
                mobnames.add(after);
            }
            Collections.sort(mobnames);
            String output = "";
            for (String mobname : mobnames) {
                if (output != "") {
                    output = output + ", ";
                }
                output = output + mobname;
            }
            output = output + ".";
            StringFunctions.sendMessage((CommandSource)source, (String)"Available entity names:", (TextFormatting)TextFormatting.DARK_GREEN, (boolean)true);
            StringFunctions.sendMessage((CommandSource)source, (String)output, (TextFormatting)TextFormatting.YELLOW);
            StringFunctions.sendMessage((CommandSource)source, (String)"To add a drop: /cemd addhand <entity-name>", (TextFormatting)TextFormatting.DARK_GRAY);
            StringFunctions.sendMessage((CommandSource)source, (String)"Note: for modded entities use - not :", (TextFormatting)TextFormatting.RED);
            StringFunctions.sendMessage((CommandSource)source, (String)"", (TextFormatting)TextFormatting.RED);
            return 1;
        }))).then(Commands.func_197057_a((String)"reload").executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            try {
                Util.loadMobConfigFile();
            }
            catch (Exception ex) {
                StringFunctions.sendMessage((CommandSource)source, (String)"Something went wrong while reloading the mob drop config file.", (TextFormatting)TextFormatting.RED);
                ex.printStackTrace();
                return 0;
            }
            StringFunctions.sendMessage((CommandSource)source, (String)"Successfully loaded the mob drop config file.", (TextFormatting)TextFormatting.DARK_GREEN);
            return 1;
        }))).then(Commands.func_197057_a((String)"addhand").then(Commands.func_197056_a((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandCemd.processAddhand((CommandContext<CommandSource>)command, 1.0))))).then(Commands.func_197057_a((String)"addhand").then(Commands.func_197056_a((String)"entity-name", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"drop-chance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            double chance = DoubleArgumentType.getDouble((CommandContext)command, (String)"drop-chance");
            if (chance < 0.0 || chance > 1.0) {
                StringFunctions.sendMessage((CommandSource)source, (String)"The chance has to be in between 0 and 1.0.", (TextFormatting)TextFormatting.RED);
                return 0;
            }
            return CommandCemd.processAddhand((CommandContext<CommandSource>)command, chance);
        }))))).then(Commands.func_197057_a((String)"cleardrops").then(Commands.func_197056_a((String)"entity-name", (ArgumentType)StringArgumentType.word()).executes(command -> {
            CommandSource source = (CommandSource)command.getSource();
            String entityname = StringArgumentType.getString((CommandContext)command, (String)"entity-name").toLowerCase().trim();
            EntityType<?> entitytype = null;
            for (EntityType<?> et : Util.mobdrops.keySet()) {
                String registrystring = et.getRegistryName().toString();
                if (!registrystring.contains(":")) continue;
                if (entityname.contains("-")) {
                    if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                    entitytype = et;
                    break;
                }
                if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
                entitytype = et;
                break;
            }
            if (entitytype == null) {
                StringFunctions.sendMessage((CommandSource)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (TextFormatting)TextFormatting.RED);
                CommandCemd.showList(source);
                return 0;
            }
            if (!Util.mobdrops.containsKey(entitytype)) {
                StringFunctions.sendMessage((CommandSource)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (TextFormatting)TextFormatting.RED);
                CommandCemd.showList(source);
                return 0;
            }
            Util.mobdrops.put(entitytype, new CopyOnWriteArrayList());
            try {
                if (!Util.writeDropsMapToFile()) {
                    StringFunctions.sendMessage((CommandSource)source, (String)"!Something went wrong while writing the new config.", (TextFormatting)TextFormatting.RED);
                }
            }
            catch (Exception ex) {
                StringFunctions.sendMessage((CommandSource)source, (String)"Something went wrong while writing the new config.", (TextFormatting)TextFormatting.RED);
                ex.printStackTrace();
            }
            StringFunctions.sendMessage((CommandSource)source, (String)("Successfully cleared all drops for the entity '" + entitytype.func_212546_e().getString() + "'."), (TextFormatting)TextFormatting.DARK_GREEN);
            return 1;
        }))));
    }

    private static int processAddhand(CommandContext<CommandSource> command, double dropchance) {
        ServerPlayerEntity player;
        CommandSource source = (CommandSource)command.getSource();
        try {
            player = source.func_197035_h();
        }
        catch (CommandSyntaxException ex) {
            StringFunctions.sendMessage((CommandSource)source, (String)"This command can only be executed as a player in-game.", (TextFormatting)TextFormatting.RED);
            return 1;
        }
        String entityname = StringArgumentType.getString(command, (String)"entity-name").toLowerCase().trim();
        EntityType<?> entitytype = null;
        for (EntityType<?> et : Util.mobdrops.keySet()) {
            String registrystring = et.getRegistryName().toString();
            if (!registrystring.contains(":")) continue;
            if (entityname.contains("-")) {
                if (!registrystring.equalsIgnoreCase(entityname.replace("-", ":"))) continue;
                entitytype = et;
                break;
            }
            if (!registrystring.split(":")[1].equalsIgnoreCase(entityname)) continue;
            entitytype = et;
            break;
        }
        if (entitytype == null) {
            StringFunctions.sendMessage((CommandSource)source, (String)("Unable to find an entity with the name '" + entityname + "'."), (TextFormatting)TextFormatting.RED);
            CommandCemd.showList(source);
            return 0;
        }
        if (!Util.mobdrops.containsKey(entitytype)) {
            StringFunctions.sendMessage((CommandSource)source, (String)("Unable to find an entity with the name '" + entityname + "' in the drop hashmap."), (TextFormatting)TextFormatting.RED);
            CommandCemd.showList(source);
            return 0;
        }
        ItemStack hand = player.func_184614_ca();
        if (hand.func_190926_b()) {
            StringFunctions.sendMessage((CommandSource)source, (String)"Your hand is empty! Unable to add drop.", (TextFormatting)TextFormatting.RED);
            return 0;
        }
        ItemStack toadd = hand.func_77946_l();
        CompoundNBT nbt = toadd.func_196082_o();
        nbt.func_74780_a("dropchance", dropchance);
        toadd.func_77982_d(nbt);
        Util.mobdrops.get(entitytype).add(toadd.func_77946_l());
        try {
            if (!Util.writeDropsMapToFile()) {
                StringFunctions.sendMessage((CommandSource)source, (String)"!Something went wrong while writing the new config.", (TextFormatting)TextFormatting.RED);
            }
        }
        catch (Exception ex) {
            StringFunctions.sendMessage((CommandSource)source, (String)"Something went wrong while writing the new config.", (TextFormatting)TextFormatting.RED);
            ex.printStackTrace();
        }
        StringFunctions.sendMessage((CommandSource)source, (String)("Successfully added '" + toadd.func_190916_E() + " " + toadd.func_200301_q().getString().toLowerCase() + "' as a drop for the entity '" + entitytype.func_212546_e().getString() + "' with a drop chance of '" + dropchance + "'."), (TextFormatting)TextFormatting.DARK_GREEN);
        return 1;
    }

    private static void showUsage(CommandSource source) {
        StringFunctions.sendMessage((CommandSource)source, (String)"Configurable Extra Mob Drops Usage:", (TextFormatting)TextFormatting.DARK_GREEN, (boolean)true);
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd usage", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Show this message.", (TextFormatting)TextFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd list", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Lists available entities to add drops to.", (TextFormatting)TextFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd reload", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Reloads the config file.", (TextFormatting)TextFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd addhand <entity-name>", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Add your hand to the entity's drops with a 100% chance.", (TextFormatting)TextFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd addhand <entity-name> <drop-chance>", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Add your hand to the entity's drops with drop-chance in between 0 and 1.0.", (TextFormatting)TextFormatting.DARK_GRAY);
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd cleardrops <entity-name>", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Clears all drops of the specified entity.", (TextFormatting)TextFormatting.DARK_GRAY);
    }

    private static void showList(CommandSource source) {
        StringFunctions.sendMessage((CommandSource)source, (String)" /cemd list", (TextFormatting)TextFormatting.DARK_GREEN);
        StringFunctions.sendMessage((CommandSource)source, (String)"  Lists available entities to add drops to.", (TextFormatting)TextFormatting.DARK_GRAY);
    }
}

