/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CraftingTableBlock;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.RegistryEntries;
import org.cyclops.commoncapabilities.api.capability.block.BlockCapabilities;
import org.cyclops.commoncapabilities.api.capability.block.IBlockCapabilityConstructor;
import org.cyclops.commoncapabilities.api.capability.block.IBlockCapabilityProvider;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.capability.recipehandler.RecipeHandlerConfig;
import org.cyclops.commoncapabilities.capability.temperature.TemperatureConfig;
import org.cyclops.commoncapabilities.capability.worker.WorkerConfig;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemFrameEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFrameFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaBlockComposterItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemFrameItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaItemShulkerBoxItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaBrewingStandRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaAbstractFurnaceTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaCampfireTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaUniversalBucketTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaAbstractFurnaceWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaBrewingStandWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaCampfireWorker;
import org.cyclops.cyclopscore.modcompat.ICompatInitializer;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class VanillaModCompat
implements IModCompat {
    public String getId() {
        return "minecraft";
    }

    public boolean isEnabledDefault() {
        return true;
    }

    public String getComment() {
        return "Furnace and Brewing stand capabilities.";
    }

    public ICompatInitializer createInitializer() {
        return () -> {
            CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
            registry.registerTile(FurnaceTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, FurnaceTileEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(FurnaceTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceWorker((AbstractFurnaceTileEntity)host));
                }
            });
            registry.registerTile(BlastFurnaceTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, BlastFurnaceTileEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BlastFurnaceTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceWorker((AbstractFurnaceTileEntity)host));
                }
            });
            registry.registerTile(SmokerTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, SmokerTileEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(SmokerTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceWorker((AbstractFurnaceTileEntity)host));
                }
            });
            registry.registerTile(BrewingStandTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, BrewingStandTileEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(BrewingStandTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaBrewingStandWorker(host));
                }
            });
            registry.registerTile(CampfireTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<IWorker, CampfireTileEntity>(){

                public Capability<IWorker> getCapability() {
                    return WorkerConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(CampfireTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaCampfireWorker(host));
                }
            });
            registry.registerTile(FurnaceTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, FurnaceTileEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(FurnaceTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceTemperature((AbstractFurnaceTileEntity)host));
                }
            });
            registry.registerTile(BlastFurnaceTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, BlastFurnaceTileEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BlastFurnaceTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceTemperature((AbstractFurnaceTileEntity)host));
                }
            });
            registry.registerTile(SmokerTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, SmokerTileEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(SmokerTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaAbstractFurnaceTemperature((AbstractFurnaceTileEntity)host));
                }
            });
            registry.registerTile(CampfireTileEntity.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITemperature, CampfireTileEntity>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(CampfireTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaCampfireTemperature(host));
                }
            });
            registry.registerItem(BucketItem.class, (ICapabilityConstructor)new ICapabilityConstructor<ITemperature, BucketItem, ItemStack>(){

                public Capability<ITemperature> getCapability() {
                    return TemperatureConfig.CAPABILITY;
                }

                public ICapabilityProvider createProvider(BucketItem hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaUniversalBucketTemperature(host));
                }
            });
            ICapabilityConstructor<IItemHandler, Item, ItemStack> shulkerboxConstructor = new ICapabilityConstructor<IItemHandler, Item, ItemStack>(){

                public Capability<IItemHandler> getCapability() {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(Item hostType, ItemStack host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)new VanillaItemShulkerBoxItemHandler(host));
                }
            };
            registry.registerItem(() -> RegistryEntries.ITEM_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_WHITE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_ORANGE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_MAGENTA_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIGHT_BLUE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_YELLOW_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIME_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_PINK_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_GRAY_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIGHT_GRAY_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_CYAN_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_PURPLE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BLUE_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BROWN_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_GREEN_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_RED_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BLACK_SHULKER_BOX, (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerEntity(ItemEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, ItemEntity, ItemEntity>(){

                public Capability<IItemHandler> getCapability() {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemEntity hostType, final ItemEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && host.func_92059_d().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemItemHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemFrameEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IItemHandler, ItemFrameEntity, ItemFrameEntity>(){

                public Capability<IItemHandler> getCapability() {
                    return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemFrameEntity hostType, final ItemFrameEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && host.func_82335_i().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFrameItemHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return Blocks.field_222436_lZ;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                                return LazyOptional.of(() -> new VanillaBlockComposterItemHandler(blockState, (IWorld)world, pos, facing)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IFluidHandler, ItemEntity, ItemEntity>(){

                public Capability<IFluidHandler> getCapability() {
                    return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemEntity hostType, final ItemEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && host.func_92059_d().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFluidHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemFrameEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IFluidHandler, ItemFrameEntity, ItemFrameEntity>(){

                public Capability<IFluidHandler> getCapability() {
                    return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemFrameEntity hostType, final ItemFrameEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && host.func_82335_i().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFrameFluidHandler(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IEnergyStorage, ItemEntity, ItemEntity>(){

                public Capability<IEnergyStorage> getCapability() {
                    return CapabilityEnergy.ENERGY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemEntity hostType, final ItemEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == CapabilityEnergy.ENERGY && host.func_92059_d().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemEnergyStorage(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerEntity(ItemFrameEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IEnergyStorage, ItemFrameEntity, ItemFrameEntity>(){

                public Capability<IEnergyStorage> getCapability() {
                    return CapabilityEnergy.ENERGY;
                }

                @Nullable
                public ICapabilityProvider createProvider(ItemFrameEntity hostType, final ItemFrameEntity host) {
                    return new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
                            return capability == CapabilityEnergy.ENERGY && host.func_82335_i().getCapability(capability, facing).isPresent() ? LazyOptional.of(() -> new VanillaEntityItemFrameEnergyStorage(host, facing)).cast() : LazyOptional.empty();
                        }
                    };
                }
            });
            registry.registerTile(BrewingStandTileEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, BrewingStandTileEntity, BrewingStandTileEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BrewingStandTileEntity hostType, BrewingStandTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, (Object)VanillaBrewingStandRecipeHandler.getInstance());
                }
            });
            registry.registerTile(FurnaceTileEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, FurnaceTileEntity, FurnaceTileEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(FurnaceTileEntity hostType, FurnaceTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((FurnaceTileEntity)host).func_145831_w(), IRecipeType.field_222150_b, size -> size == 1));
                }
            });
            registry.registerTile(BlastFurnaceTileEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, BlastFurnaceTileEntity, BlastFurnaceTileEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(BlastFurnaceTileEntity hostType, BlastFurnaceTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((BlastFurnaceTileEntity)host).func_145831_w(), IRecipeType.field_222151_c, size -> size == 1));
                }
            });
            registry.registerTile(SmokerTileEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, SmokerTileEntity, SmokerTileEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(SmokerTileEntity hostType, SmokerTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((SmokerTileEntity)host).func_145831_w(), IRecipeType.field_222152_d, size -> size == 1));
                }
            });
            registry.registerTile(CampfireTileEntity.class, (ICapabilityConstructor)new ICapabilityConstructor<IRecipeHandler, CampfireTileEntity, CampfireTileEntity>(){

                public Capability<IRecipeHandler> getCapability() {
                    return RecipeHandlerConfig.CAPABILITY;
                }

                @Nullable
                public ICapabilityProvider createProvider(CampfireTileEntity hostType, CampfireTileEntity host) {
                    return new DefaultCapabilityProvider(this::getCapability, new VanillaRecipeTypeRecipeHandler(() -> ((CampfireTileEntity)host).func_145831_w(), IRecipeType.field_222153_e, size -> size == 1));
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return null;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (blockState.func_177230_c() instanceof CraftingTableBlock && capability == RecipeHandlerConfig.CAPABILITY) {
                                return LazyOptional.of(() -> new VanillaRecipeTypeRecipeHandler(() -> (World)world, IRecipeType.field_222149_a, size -> size > 0)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
            BlockCapabilities.getInstance().register(new IBlockCapabilityConstructor(){

                @Override
                @Nullable
                public Block getBlock() {
                    return Blocks.field_222430_lS;
                }

                @Override
                public IBlockCapabilityProvider createProvider() {
                    return new IBlockCapabilityProvider(){

                        @Override
                        public <T> LazyOptional<T> getCapability(@Nonnull BlockState blockState, @Nonnull Capability<T> capability, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nullable Direction facing) {
                            if (capability == RecipeHandlerConfig.CAPABILITY) {
                                return LazyOptional.of(() -> new VanillaRecipeTypeRecipeHandler(() -> (World)world, IRecipeType.field_222154_f, size -> size == 1)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    };
                }
            });
        };
    }
}

