/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.OpenGLUtils;
import java.util.function.BooleanSupplier;

public enum UniformType {
    INT(Carrier.INT, () -> OpenGLUtils.openGL20, 1),
    U_INT(Carrier.U_INT, () -> OpenGLUtils.openGL20, 1),
    FLOAT(Carrier.FLOAT, () -> OpenGLUtils.openGL20, 1),
    VEC2(Carrier.FLOAT, () -> OpenGLUtils.openGL20, 2),
    I_VEC2(Carrier.INT, () -> OpenGLUtils.openGL20, 2),
    U_VEC2(Carrier.U_INT, () -> OpenGLUtils.openGL20, 2),
    B_VEC2(Carrier.INT, () -> OpenGLUtils.openGL20, 2),
    VEC3(Carrier.FLOAT, () -> OpenGLUtils.openGL20, 3),
    I_VEC3(Carrier.INT, () -> OpenGLUtils.openGL20, 3),
    U_VEC3(Carrier.U_INT, () -> OpenGLUtils.openGL20, 3),
    B_VEC3(Carrier.INT, () -> OpenGLUtils.openGL20, 3),
    VEC4(Carrier.FLOAT, () -> OpenGLUtils.openGL20, 4),
    I_VEC4(Carrier.INT, () -> OpenGLUtils.openGL20, 4),
    U_VEC4(Carrier.U_INT, () -> OpenGLUtils.openGL20, 4),
    B_VEC4(Carrier.INT, () -> OpenGLUtils.openGL20, 4),
    MAT2(Carrier.MATRIX, () -> OpenGLUtils.openGL20, 4),
    MAT2x3(Carrier.MATRIX, () -> OpenGLUtils.openGL21, 6),
    MAT2x4(Carrier.MATRIX, () -> OpenGLUtils.openGL21, 8),
    MAT3(Carrier.MATRIX, () -> OpenGLUtils.openGL20, 9),
    MAT3x2(Carrier.MATRIX, () -> OpenGLUtils.openGL21, 6),
    MAT3x4(Carrier.MATRIX, () -> OpenGLUtils.openGL21, 12),
    MAT4(Carrier.MATRIX, () -> OpenGLUtils.openGL20, 16),
    MAT4x2(Carrier.MATRIX, () -> OpenGLUtils.openGL21, 8),
    MAT4x3(Carrier.MATRIX, () -> OpenGLUtils.openGL21, 12),
    DOUBLE(Carrier.DOUBLE, () -> OpenGLUtils.openGL40, 1),
    D_VEC2(Carrier.DOUBLE, () -> OpenGLUtils.openGL40, 2),
    D_VEC3(Carrier.DOUBLE, () -> OpenGLUtils.openGL40, 3),
    D_VEC4(Carrier.DOUBLE, () -> OpenGLUtils.openGL40, 4),
    D_MAT2(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 4),
    D_MAT2x3(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 6),
    D_MAT2x4(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 8),
    D_MAT3(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 9),
    D_MAT3x2(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 6),
    D_MAT3x4(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 12),
    D_MAT4(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 16),
    D_MAT4x2(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 8),
    D_MAT4x3(Carrier.D_MATRIX, () -> OpenGLUtils.openGL40, 12);

    private final Carrier carrier;
    private BooleanSupplier func;
    private final int size;
    private boolean isSupported;

    private UniformType(Carrier carrier, BooleanSupplier func, int size) {
        this.carrier = carrier;
        this.func = func;
        this.size = size;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSupported() {
        if (this.func != null) {
            this.isSupported = this.func.getAsBoolean();
            this.func = null;
        }
        return this.isSupported;
    }

    public static enum Carrier {
        INT,
        U_INT,
        FLOAT,
        DOUBLE,
        MATRIX,
        D_MATRIX;

    }
}

