/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.lighting;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.PlanarLightModel;
import codechicken.lib.render.pipeline.IVertexOperation;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = IVertexOperation.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    public IBlockDisplayReader access;
    public BlockPos pos = BlockPos.field_177992_a;
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(IBlockDisplayReader a, BlockPos bPos) {
        this.access = a;
        this.pos = bPos;
        this.sampled = 0;
        return this;
    }

    public int brightness(int side) {
        if ((this.sampled & 1 << side) == 0) {
            this.brightness[side] = WorldRenderer.func_228421_a_((IBlockDisplayReader)this.access, (BlockPos)this.pos);
            this.sampled |= 1 << side;
        }
        return this.brightness[side];
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        ccrs.pipeline.addDependency(ccrs.sideAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        super.operate(ccrs);
        ccrs.brightness = this.brightness(ccrs.side);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

