/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventorySimple
implements IInventory {
    public ItemStack[] items;
    public int limit;
    public String name;

    public InventorySimple(ItemStack[] items, int limit, String name) {
        this.items = items;
        ArrayUtils.fillArray(items, ItemStack.field_190927_a, Objects::isNull);
        this.limit = limit;
        this.name = name;
    }

    public InventorySimple(ItemStack[] items, String name) {
        this(items, 64, name);
    }

    public InventorySimple(ItemStack[] items, int limit) {
        this(items, limit, "inv");
    }

    public InventorySimple(ItemStack[] items) {
        this(items, 64, "inv");
    }

    public InventorySimple(int size, int limit, String name) {
        this(new ItemStack[size], limit, name);
    }

    public InventorySimple(int size, int limit) {
        this(size, limit, "inv");
    }

    public InventorySimple(int size, String name) {
        this(size, 64, name);
    }

    public InventorySimple(int size) {
        this(size, 64, "inv");
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public boolean func_191420_l() {
        return ArrayUtils.count(this.items, stack -> !stack.func_190926_b()) <= 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.limit;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public void func_174888_l() {
        Arrays.fill(this.items, ItemStack.field_190927_a);
    }
}

