/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config.parser;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigTagImpl;
import codechicken.lib.config.parser.ConfigParseException;
import codechicken.lib.config.parser.ConfigReader;
import codechicken.lib.config.parser.ConfigSerializer;
import codechicken.lib.util.SneakyUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardConfigSerializer
implements ConfigSerializer {
    private static final Logger logger = LogManager.getLogger();
    public static final StandardConfigSerializer INSTANCE = new StandardConfigSerializer();
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(?<=\")(.*)(?=\")");
    private static final Pattern STRING_MATCHER = Pattern.compile("(?<=.:\")(.*)(\"=\")(.*)(?=\")");
    private static final Set<String> validTrue = Sets.newHashSet((Object[])new String[]{"true", "yes", "1"});
    private static final Set<String> validFalse = Sets.newHashSet((Object[])new String[]{"false", "no", "0"});

    @Override
    public void parse(Path file, ConfigTagImpl rootTag) throws IOException {
        try (ConfigReader reader = new ConfigReader(Files.newBufferedReader(file));){
            this.parse(rootTag, reader);
        }
    }

    private void parse(ConfigTagImpl thisTag, ConfigReader reader) throws IOException {
        String line;
        block32: while ((line = StandardConfigSerializer.readLine(reader)) != null) {
            LinkedList<Object> list;
            ConfigTagImpl tag;
            ConfigTag.TagType type;
            block44: {
                if (line.isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
                if (line.startsWith("}")) break;
                if (line.startsWith("~")) {
                    thisTag.version = line.substring(1);
                    continue;
                }
                if (line.startsWith("\"") && line.endsWith("{")) {
                    Matcher matcher = QUOTE_PATTERN.matcher(line);
                    if (!matcher.find()) {
                        throw new ConfigParseException("Malformed line! @%s, %s", reader.getCurrLine(), line);
                    }
                    String name = matcher.group();
                    ConfigTagImpl tag2 = thisTag.getTag(name);
                    this.parse(tag2, reader);
                    continue;
                }
                boolean isList = line.endsWith("<");
                char first = line.charAt(0);
                type = ConfigTag.TagType.fromChar(first);
                if (type == null) {
                    throw new ConfigParseException("Invalid value type %s, @Line:%s, '%s'", Character.valueOf(first), reader.getCurrLine(), line);
                }
                Matcher matcher = (type != ConfigTag.TagType.STRING || isList ? QUOTE_PATTERN : STRING_MATCHER).matcher(line);
                if (!matcher.find()) {
                    throw new ConfigParseException("Malformed line! @%s, '%s'", reader.getCurrLine(), line);
                }
                String name = matcher.group(1);
                tag = thisTag.getTag(name);
                if (!isList) {
                    String value;
                    if (type == ConfigTag.TagType.STRING) {
                        value = matcher.group(3);
                    } else {
                        int equals = line.indexOf(61);
                        if (equals == -1) {
                            throw new ConfigParseException("Malformed line! @%s, '%s', Expected equals sign.", reader.getCurrLine(), line);
                        }
                        value = line.substring(equals + 1);
                    }
                    switch (type) {
                        case BOOLEAN: {
                            tag.setBoolean(StandardConfigSerializer.parseBoolean(value, reader.getCurrLine()));
                            continue block32;
                        }
                        case STRING: {
                            tag.setString(value);
                            continue block32;
                        }
                        case INT: {
                            try {
                                tag.setInt(Integer.parseInt(value));
                                continue block32;
                            }
                            catch (NumberFormatException e) {
                                throw new ConfigParseException(e, "Malformed line!, @%s, '%s'", reader.getCurrLine(), line);
                            }
                        }
                        case LONG: {
                            try {
                                tag.setLong(Long.parseLong(value));
                                continue block32;
                            }
                            catch (NumberFormatException e) {
                                throw new ConfigParseException(e, "Malformed line!, @%s, '%s'", reader.getCurrLine(), line);
                            }
                        }
                        case HEX: {
                            try {
                                tag.setHex((int)Long.parseLong(value.replace("0x", ""), 16));
                                continue block32;
                            }
                            catch (NumberFormatException e) {
                                throw new ConfigParseException(e, "Malformed line!, @%s, '%s'", reader.getCurrLine(), line);
                            }
                        }
                        case DOUBLE: {
                            try {
                                tag.setDouble(Double.parseDouble(value));
                                continue block32;
                            }
                            catch (NumberFormatException e) {
                                throw new ConfigParseException(e, "Malformed line!, @%s, '%s'", reader.getCurrLine(), line);
                            }
                        }
                    }
                }
                list = new LinkedList<Object>();
                block33: while (true) {
                    String listLine;
                    if ((listLine = StandardConfigSerializer.readLine(reader)) == null) {
                        throw new EOFException("End of line reached whilst parsing list?");
                    }
                    if (listLine.isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
                    if (listLine.startsWith(">")) break block44;
                    switch (type) {
                        case BOOLEAN: {
                            list.add(StandardConfigSerializer.parseBoolean(listLine, reader.getCurrLine()));
                            continue block33;
                        }
                        case STRING: {
                            list.add(listLine);
                            continue block33;
                        }
                        case INT: {
                            list.add(Integer.parseInt(listLine));
                            continue block33;
                        }
                        case LONG: {
                            list.add(Long.parseLong(listLine));
                            continue block33;
                        }
                        case HEX: {
                            list.add((int)Long.parseLong(listLine.replace("0x", ""), 16));
                            continue block33;
                        }
                        case DOUBLE: {
                            list.add(Double.parseDouble(listLine));
                            continue block33;
                        }
                    }
                    break;
                }
                throw new ConfigParseException("Invalid type state at list parsing?? %s", line);
            }
            switch (type) {
                case BOOLEAN: {
                    tag.setBooleanList(list);
                    break;
                }
                case STRING: {
                    tag.setStringList(list);
                    break;
                }
                case INT: {
                    tag.setIntList(list);
                    break;
                }
                case LONG: {
                    tag.setLongList(list);
                    break;
                }
                case HEX: {
                    tag.setHexList(list);
                    break;
                }
                case DOUBLE: {
                    tag.setDoubleList(list);
                }
            }
        }
    }

    private static boolean parseBoolean(String value, int line) throws IOException {
        Boolean bool = null;
        if (validTrue.contains(value.toLowerCase(Locale.US))) {
            bool = true;
        } else if (validFalse.contains(value.toLowerCase(Locale.US))) {
            bool = false;
        }
        if (bool == null) {
            throw new ConfigParseException("Invalid Boolean qualifier! %s on line: %s, supported: %s", value, line, Joiner.on((String)", ").join(Iterables.concat(validTrue, validFalse)));
        }
        return bool;
    }

    protected static String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        return line == null ? null : line.trim();
    }

    @Override
    public void save(Path file, ConfigTag tag) {
        if (Files.exists(file, new LinkOption[0])) {
            SneakyUtils.sneaky(() -> Files.delete(file));
        }
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            SneakyUtils.sneaky(() -> Files.createDirectories(file.getParent(), new FileAttribute[0]));
        }
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(file, StandardOpenOption.CREATE));){
            this.writeTag((ConfigTagImpl)tag, writer, 0);
        }
        catch (IOException e) {
            logger.error("Failed to save config file: {}", (Object)file, (Object)e);
        }
    }

    private void writeTag(ConfigTagImpl tag, PrintWriter writer, int depth) {
        if (tag.isCategory()) {
            if (tag.version != null) {
                StandardConfigSerializer.writeLine(writer, depth, "~%s", tag.version);
                writer.println();
            }
            Iterator<Map.Entry<String, ConfigTagImpl>> iterator = tag.children.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ConfigTagImpl> entry = iterator.next();
                int inc = 0;
                for (String comment : entry.getValue().comment) {
                    StandardConfigSerializer.writeLine(writer, depth, "# " + comment, new Object[0]);
                }
                if (entry.getValue().isCategory()) {
                    StandardConfigSerializer.writeLine(writer, depth, "\"%s\" {", entry.getKey());
                    ++inc;
                }
                this.writeTag(entry.getValue(), writer, depth + inc);
                if (entry.getValue().isCategory()) {
                    StandardConfigSerializer.writeLine(writer, depth, "}", new Object[0]);
                }
                if (!iterator.hasNext()) continue;
                writer.println();
            }
        } else if (tag.isValue()) {
            switch (tag.type) {
                case STRING: {
                    StandardConfigSerializer.writeLine(writer, depth, "%s:\"%s\"=\"%s\"", Character.valueOf(tag.type.getChar()), tag.name, tag.value);
                    break;
                }
                case BOOLEAN: 
                case INT: 
                case LONG: 
                case HEX: 
                case DOUBLE: {
                    StandardConfigSerializer.writeLine(writer, depth, "%s:\"%s\"=%s", Character.valueOf(tag.type.getChar()), tag.name, tag.type.processLine(tag.value));
                    break;
                }
                case LIST: {
                    StandardConfigSerializer.writeLine(writer, depth, "%s:\"%s\" <", Character.valueOf(tag.listType.getChar()), tag.name);
                    for (Object object : (List)tag.value) {
                        StandardConfigSerializer.writeLine(writer, depth + 1, "%s", tag.listType.processLine(object));
                    }
                    StandardConfigSerializer.writeLine(writer, depth, ">", new Object[0]);
                }
            }
        } else {
            throw new IllegalStateException("Somehow a tag is not a category or a value..");
        }
    }

    private static void writeLine(PrintWriter writer, int tabs, String line, Object ... data) {
        for (int i = 0; i < tabs; ++i) {
            writer.print('\t');
        }
        writer.println(String.format(line, data));
    }
}

