/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.Copyable;
import codechicken.lib.util.TransformUtils;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ModelProperties
implements Copyable<ModelProperties> {
    public static final ModelProperties DEFAULT_ITEM = ModelProperties.builder().withAO(true).build();
    public static final ModelProperties DEFAULT_BLOCK = ModelProperties.builder().withAO(true).withGui3D(true).withUsesBlockLight(true).build();
    private final boolean isAO;
    private final boolean isGui3D;
    private final boolean isBuiltInRenderer;
    private final boolean usesBlockLight;
    @Nullable
    private TextureAtlasSprite particle;

    public ModelProperties(boolean isAO, boolean isGui3D) {
        this(isAO, isGui3D, false, null);
    }

    public ModelProperties(boolean isAO, boolean isGui3D, TextureAtlasSprite sprite) {
        this(isAO, isGui3D, false, false, sprite);
    }

    @Deprecated
    public ModelProperties(boolean isAO, boolean isGui3D, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
        this(isAO, isGui3D, isBuiltInRenderer, false, particle);
    }

    public ModelProperties(ModelProperties properties) {
        this(properties, properties.particle);
    }

    public ModelProperties(ModelProperties properties, TextureAtlasSprite sprite) {
        this(properties.isAmbientOcclusion(), properties.isGui3d(), properties.usesBlockLight(), properties.isBuiltInRenderer(), sprite);
    }

    public ModelProperties(boolean isAO, boolean isGui3D, boolean usesBlockLight, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
        this.isAO = isAO;
        this.isGui3D = isGui3D;
        this.isBuiltInRenderer = isBuiltInRenderer;
        this.usesBlockLight = usesBlockLight;
        this.particle = particle;
    }

    public static ModelProperties createFromModel(IBakedModel model) {
        return new ModelProperties(model.func_177555_b(), model.func_177556_c(), model.func_188618_c(), model.func_177554_e());
    }

    public boolean isAmbientOcclusion() {
        return this.isAO;
    }

    public boolean isGui3d() {
        return this.isGui3D;
    }

    public boolean isBuiltInRenderer() {
        return this.isBuiltInRenderer;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public TextureAtlasSprite getParticleTexture() {
        if (this.particle == null) {
            this.particle = TextureUtils.getMissingSprite();
        }
        return this.particle;
    }

    @Override
    public ModelProperties copy() {
        return new ModelProperties(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isAO;
        private boolean isGui3D;
        private boolean isBuiltInRenderer;
        private boolean usesBlockLight;
        private TextureAtlasSprite particle;

        protected Builder() {
        }

        @Deprecated
        protected Builder(boolean isAO, boolean isGui3D, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
            this(isAO, isGui3D, false, isBuiltInRenderer, particle);
        }

        protected Builder(boolean isAO, boolean isGui3D, boolean usesBlockLight, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
            this.isAO = isAO;
            this.isGui3D = isGui3D;
            this.usesBlockLight = usesBlockLight;
            this.isBuiltInRenderer = isBuiltInRenderer;
            this.particle = particle;
        }

        public Builder copyFrom(IBakedModel model) {
            this.isAO = model.func_177555_b();
            this.isGui3D = model.func_177556_c();
            this.usesBlockLight = model.func_230044_c_();
            this.isBuiltInRenderer = model.func_188618_c();
            this.particle = model.func_177554_e();
            return this;
        }

        public Builder copyFrom(ModelProperties properties) {
            this.isAO = properties.isAO;
            this.isGui3D = properties.isGui3D;
            this.isBuiltInRenderer = properties.isBuiltInRenderer;
            this.particle = properties.particle;
            return this;
        }

        public Builder withAO(boolean isAO) {
            this.isAO = isAO;
            return this;
        }

        public Builder withGui3D(boolean isGui3D) {
            this.isGui3D = isGui3D;
            return this;
        }

        public Builder withUsesBlockLight(boolean usesBlockLight) {
            this.usesBlockLight = usesBlockLight;
            return this;
        }

        public Builder withBuiltInRenderer(boolean builtInRenderer) {
            this.isBuiltInRenderer = builtInRenderer;
            return this;
        }

        public Builder withParticle(TextureAtlasSprite sprite) {
            this.particle = sprite;
            return this;
        }

        public PerspectiveProperties.PerspectiveBuilder withTransforms(IModelTransform transforms) {
            PerspectiveProperties.PerspectiveBuilder builder = new PerspectiveProperties.PerspectiveBuilder(this);
            builder.withTransforms(transforms);
            return builder;
        }

        public ModelProperties build() {
            return new ModelProperties(this.isAO, this.isGui3D, this.isBuiltInRenderer, this.particle);
        }
    }

    public static class PerspectiveProperties
    extends ModelProperties {
        public static final PerspectiveProperties DEFAULT_ITEM = ModelProperties.builder().copyFrom(DEFAULT_ITEM).withTransforms(TransformUtils.DEFAULT_ITEM).build();
        public static final PerspectiveProperties DEFAULT_BLOCK = ModelProperties.builder().copyFrom(DEFAULT_BLOCK).withTransforms(TransformUtils.DEFAULT_BLOCK).build();
        private final IModelTransform transforms;

        public PerspectiveProperties(IModelTransform transforms, boolean isAO, boolean isGui3D) {
            this(transforms, isAO, isGui3D, false, null);
        }

        @Deprecated
        public PerspectiveProperties(IModelTransform transforms, boolean isAO, boolean isGui3D, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
            this(transforms, isAO, isGui3D, false, isBuiltInRenderer, particle);
        }

        public PerspectiveProperties(IModelTransform transforms, boolean isAO, boolean isGui3D, boolean usesBlockLight, boolean isBuiltInRenderer, TextureAtlasSprite particle) {
            this(transforms, new ModelProperties(isAO, isGui3D, usesBlockLight, isBuiltInRenderer, particle));
        }

        public PerspectiveProperties(PerspectiveProperties properties) {
            this(properties.getTransforms(), properties);
        }

        public PerspectiveProperties(IModelTransform transforms, ModelProperties properties) {
            super(properties);
            this.transforms = transforms;
        }

        public IModelTransform getTransforms() {
            return this.transforms;
        }

        @Override
        public PerspectiveProperties copy() {
            return new PerspectiveProperties(this);
        }

        public static class PerspectiveBuilder
        extends Builder {
            private IModelTransform transforms;

            protected PerspectiveBuilder(Builder builder) {
                super(builder.isAO, builder.isAO, builder.usesBlockLight, builder.isBuiltInRenderer, builder.particle);
            }

            @Override
            public PerspectiveBuilder withTransforms(IModelTransform transforms) {
                this.transforms = transforms;
                return this;
            }

            @Override
            public PerspectiveProperties build() {
                return new PerspectiveProperties(this.transforms, super.build());
            }
        }
    }
}

