/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BooleanListEntry
extends TooltipListEntry<Boolean> {
    private final AtomicBoolean bool;
    private final boolean original;
    private final Button buttonWidget;
    private final Button resetButton;
    private final Consumer<Boolean> saveConsumer;
    private final Supplier<Boolean> defaultValue;
    private final List<IGuiEventListener> widgets;

    @Deprecated
    public BooleanListEntry(ITextComponent fieldName, boolean bool, ITextComponent resetButtonKey, Supplier<Boolean> defaultValue, Consumer<Boolean> saveConsumer) {
        this(fieldName, bool, resetButtonKey, defaultValue, saveConsumer, null);
    }

    @Deprecated
    public BooleanListEntry(ITextComponent fieldName, boolean bool, ITextComponent resetButtonKey, Supplier<Boolean> defaultValue, Consumer<Boolean> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, bool, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    public BooleanListEntry(ITextComponent fieldName, boolean bool, ITextComponent resetButtonKey, Supplier<Boolean> defaultValue, Consumer<Boolean> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.original = bool;
        this.bool = new AtomicBoolean(bool);
        this.buttonWidget = new Button(0, 0, 150, 20, NarratorChatListener.field_216868_a, widget -> this.bool.set(!this.bool.get()));
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.bool.set((Boolean)defaultValue.get()));
        this.saveConsumer = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.buttonWidget, this.resetButton});
    }

    @Override
    public boolean isEdited() {
        return super.isEdited() || this.original != this.bool.get();
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public Boolean getValue() {
        return this.bool.get();
    }

    @Override
    public Optional<Boolean> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.field_230693_o_ = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().booleanValue() != this.bool.get();
        this.resetButton.field_230691_m_ = y;
        this.buttonWidget.field_230693_o_ = this.isEditable();
        this.buttonWidget.field_230691_m_ = y;
        this.buttonWidget.func_238482_a_(this.getYesNoText(this.bool.get()));
        ITextComponent displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)displayedFieldName)), (float)(y + 5), 0xFFFFFF);
            this.resetButton.field_230690_l_ = x;
            this.buttonWidget.field_230690_l_ = x + this.resetButton.func_230998_h_() + 2;
        } else {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x + entryWidth - this.resetButton.func_230998_h_();
            this.buttonWidget.field_230690_l_ = x + entryWidth - 150;
        }
        this.buttonWidget.func_230991_b_(150 - this.resetButton.func_230998_h_() - 2);
        this.resetButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.buttonWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public ITextComponent getYesNoText(boolean bool) {
        return new TranslationTextComponent("text.cloth-config.boolean.value." + bool);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }
}

