/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="clienttweaks", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final Map<KeyBinding, AbstractClientTweak> toggleableTweaks = new HashMap<KeyBinding, AbstractClientTweak>();

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1) {
            for (Map.Entry<KeyBinding, AbstractClientTweak> entry : toggleableTweaks.entrySet()) {
                InputMappings.Input input = InputMappings.func_197954_a((int)event.getKey(), (int)event.getScanCode());
                if (!entry.getKey().isActiveAndMatches(input)) continue;
                ClientEventHandler.toggleTweak(entry.getValue());
            }
        }
    }

    private static void toggleTweak(AbstractClientTweak tweak) {
        tweak.setEnabled(!tweak.isEnabled());
        ClientTweaksConfig.save();
        StringTextComponent root = new StringTextComponent(tweak.getName() + ": ");
        root.func_230529_a_((ITextComponent)new TranslationTextComponent(tweak.isEnabled() ? "chat.clienttweaks.on" : "chat.clienttweaks.off"));
        Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)root, true);
    }

    public static void setupKeyBindings(Collection<AbstractClientTweak> tweaks) {
        for (AbstractClientTweak tweak : tweaks) {
            if (!tweak.hasKeyBinding()) continue;
            KeyBinding keyBinding = new KeyBinding("key.clienttweaks." + tweak.getName(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.clienttweaks");
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
            toggleableTweaks.put(keyBinding, tweak);
        }
    }
}

