/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.network.NetworkEvent;
import team.chisel.api.IChiselItem;
import team.chisel.common.util.NBTUtil;

public class PacketHitechSettings {
    private final byte type;
    private final boolean rotate;
    private final int chiselSlot;

    public PacketHitechSettings(@Nonnull ItemStack stack, int chiselSlot) {
        this.type = (byte)NBTUtil.getHitechType(stack).ordinal();
        this.rotate = NBTUtil.getHitechRotate(stack);
        this.chiselSlot = chiselSlot;
    }

    public void encode(ByteBuf buf) {
        buf.writeByte((int)this.type);
        buf.writeBoolean(this.rotate);
        buf.writeByte(this.chiselSlot);
    }

    public static PacketHitechSettings decode(ByteBuf buf) {
        return new PacketHitechSettings(buf.readByte(), buf.readBoolean(), buf.readByte());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ItemStack stack = ctx.get().getSender().field_71071_by.func_70301_a(this.chiselSlot);
        if (stack.func_77973_b() instanceof IChiselItem) {
            NBTUtil.setHitechType(stack, this.type);
            NBTUtil.setHitechRotate(stack, this.rotate);
        }
        ctx.get().setPacketHandled(true);
    }

    public PacketHitechSettings(byte type, boolean rotate, int chiselSlot) {
        this.type = type;
        this.rotate = rotate;
        this.chiselSlot = chiselSlot;
    }
}

