/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.IVariationRegistry;
import team.chisel.common.inventory.ContainerChiselHitech;
import team.chisel.common.inventory.SlotChiselSelection;
import team.chisel.common.util.SoundUtil;

public class PacketChiselButton {
    @Nonnull
    private final int[] slotIds;

    public PacketChiselButton(int ... slots) {
        this.slotIds = slots;
    }

    public void encode(PacketBuffer buf) {
        buf.func_186875_a(this.slotIds);
    }

    public static PacketChiselButton decode(PacketBuffer buf) {
        return new PacketChiselButton(buf.func_186863_b());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> PacketChiselButton.chiselAll((PlayerEntity)player, this.slotIds));
        ctx.get().setPacketHandled(true);
    }

    public static void chiselAll(PlayerEntity player, int[] slots) {
        if (player.field_71070_bA instanceof ContainerChiselHitech) {
            ContainerChiselHitech container = (ContainerChiselHitech)player.field_71070_bA;
            ItemStack chisel = container.getChisel();
            ItemStack originalChisel = chisel.func_77946_l();
            ItemStack target = container.getTargetStack();
            if (!(chisel.func_77973_b() instanceof IChiselItem)) {
                return;
            }
            IVariationRegistry carving = CarvingUtils.getChiselRegistry();
            if (chisel.func_190926_b() || target.func_190926_b()) {
                return;
            }
            boolean playSound = false;
            for (int i : slots) {
                ItemStack s = player.field_71071_by.func_70301_a(i);
                if (!s.func_190926_b()) {
                    if (!carving.getGroup(target.func_77973_b()).map(ICarvingGroup::getId).flatMap(id -> carving.getGroup(s.func_77973_b()).map(g -> g.getId().equals(id))).orElse(false).booleanValue()) {
                        return;
                    }
                    container.getInventoryChisel().setStackInSpecialSlot(s);
                    ItemStack res = SlotChiselSelection.craft(container, player, target.func_77946_l(), false);
                    if (!res.func_190926_b()) {
                        player.field_71071_by.func_70299_a(i, res);
                        playSound = true;
                    }
                }
                if (!chisel.func_190926_b()) continue;
                return;
            }
            container.getInventoryChisel().setStackInSpecialSlot(container.getSelectionStack());
            container.getInventoryChisel().updateItems();
            if (playSound) {
                SoundUtil.playSound(player, originalChisel, target);
            }
        }
    }
}

