/*
 * Decompiled with CFR 0.152.
 */
package team.chisel;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.IntClamper;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LimitCount;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import team.chisel.Chisel;
import team.chisel.api.block.BlockCreator;
import team.chisel.api.block.ChiselBlockFactory;
import team.chisel.api.block.VariantTemplate;
import team.chisel.client.data.ModelTemplates;
import team.chisel.client.data.VariantTemplates;
import team.chisel.client.sound.ChiselSoundTypes;
import team.chisel.common.block.BlockCarvable;
import team.chisel.common.block.BlockCarvableCarpet;
import team.chisel.common.init.ChiselCompatTags;
import team.chisel.repack.registrate.providers.RegistrateLangProvider;
import team.chisel.repack.registrate.providers.RegistrateRecipeProvider;
import team.chisel.repack.registrate.providers.loot.RegistrateBlockLootTables;
import team.chisel.repack.registrate.util.entry.BlockEntry;

public class Features {
    private static final ChiselBlockFactory _FACTORY = ChiselBlockFactory.newFactory(Chisel.registrate());
    public static final Map<String, BlockEntry<BlockCarvable>> ALUMINUM = _FACTORY.newType(Material.field_151573_f, "metals/aluminum").setGroupName("Aluminum Block").addTag(ChiselCompatTags.STORAGE_BLOCKS_ALUMINUM).variations((Collection<VariantTemplate>)VariantTemplates.METAL).build(b -> b.func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    public static final Map<String, BlockEntry<BlockCarvable>> ANDESITE = _FACTORY.newType(Material.field_151576_e, "andesite").addBlock(Blocks.field_196656_g).addBlock(Blocks.field_196657_h).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(1.5f, 30.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> ANTIBLOCK = _FACTORY.newType(Material.field_151576_e, "antiblock", (p, v) -> new BlockCarvable(p, v)).layer(() -> RenderType::func_228643_e_).variations((Collection<VariantTemplate>)VariantTemplates.colors(ModelTemplates.twoLayerWithTop("antiblock", false), (prov, block) -> new ShapedRecipeBuilder((IItemProvider)block, 8).func_200472_a("SSS").func_200472_a("SGS").func_200472_a("SSS").func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200465_a("has_glowstone", (ICriterionInstance)RegistrateRecipeProvider.hasItem((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE)).func_200464_a((Consumer)prov))).build();
    public static final Map<String, BlockEntry<BlockCarvable>> BASALT = _FACTORY.newType(Material.field_151576_e, "basalt").variation(VariantTemplates.RAW).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).addTag(ChiselCompatTags.STONE_BASALT).build(b -> b.func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final ImmutableList<WoodType> VANILLA_WOODS = ImmutableList.of((Object)WoodType.field_227038_a_, (Object)WoodType.field_227039_b_, (Object)WoodType.field_227040_c_, (Object)WoodType.field_227041_d_, (Object)WoodType.field_227042_e_, (Object)WoodType.field_227043_f_);
    public static final Map<String, BlockEntry<BlockCarvable>> BRICKS = _FACTORY.newType(Material.field_151576_e, "bricks").addBlock(Blocks.field_196584_bK).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(p -> p.func_200948_a(2.0f, 6.0f));
    public static final Map<String, BlockEntry<BlockCarvable>> BRONZE = _FACTORY.newType(Material.field_151573_f, "metals/bronze").setGroupName("Bronze Block").addTag(ChiselCompatTags.STORAGE_BLOCKS_BRONZE).variations((Collection<VariantTemplate>)VariantTemplates.METAL).build(p -> p.func_200947_a(SoundType.field_185852_e).func_200943_b(5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    public static final Map<DyeColor, Map<String, BlockEntry<BlockCarvableCarpet>>> CARPET = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), color -> _FACTORY.newType(Material.field_151580_n, "carpet/" + color.func_176610_l(), BlockCarvableCarpet::new).addBlock(new ResourceLocation(color.func_176610_l() + "_carpet")).setGroupName(RegistrateLangProvider.toEnglishName(color.func_176610_l()) + " Carpet").model((prov, block) -> prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().carpet("block/" + ModelTemplates.name(block), prov.modLoc("block/" + ModelTemplates.name(block).replace("carpet", "wool")))).texture("particle", "#wool"))).variation("legacy").next("llama").build(b -> b.func_200947_a(SoundType.field_185854_g).func_200943_b(0.8f))));
    public static final Map<String, BlockEntry<BlockCarvable>> CHARCOAL = _FACTORY.newType(Material.field_151576_e, "charcoal").addTag(ChiselCompatTags.STORAGE_BLOCKS_CHARCOAL).variation(VariantTemplates.withRecipe(VariantTemplates.RAW, (prov, block) -> new ShapelessRecipeBuilder((IItemProvider)block, 1).func_200487_b((IItemProvider)Items.field_196155_l).func_200483_a("has_charcoal", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)Items.field_196155_l)).func_200482_a((Consumer)prov))).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> COAL = _FACTORY.newType(Material.field_151576_e, "coal").addTag((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_COAL).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> COBBLESTONE = _FACTORY.newType(Material.field_151576_e, "cobblestone").addBlock(Blocks.field_150347_e).variations((Collection<VariantTemplate>)VariantTemplates.COBBLESTONE).build(b -> b.func_200948_a(2.0f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> COBBLESTONE_MOSSY = _FACTORY.newType(Material.field_151576_e, "mossy_cobblestone").addBlock(Blocks.field_150341_Y).variations((Collection<VariantTemplate>)VariantTemplates.COBBLESTONE_MOSSY).build(b -> b.func_200948_a(2.0f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<DyeColor, Map<String, BlockEntry<BlockCarvable>>> CONCRETE = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), color -> _FACTORY.newType(Material.field_151576_e, "concrete/" + color.func_176610_l()).addBlock(new ResourceLocation(color.func_176610_l() + "_concrete")).setGroupName(RegistrateLangProvider.toEnglishName(color.func_176610_l()) + " Concrete").variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(p -> p.func_200947_a(SoundType.field_185851_d).func_200943_b(1.8f))));
    public static final Map<String, BlockEntry<BlockCarvable>> DIORITE = _FACTORY.newType(Material.field_151576_e, "diorite").addBlock(Blocks.field_196654_e).addBlock(Blocks.field_196655_f).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> EMERALD = _FACTORY.newType(Material.field_151573_f, "emerald").addTag((ITag.INamedTag<Block>)BlockTags.field_232875_ap_).variation("panel").next("panelclassic").next("smooth").next("chunk").next("goldborder").next("zelda").next("cell").next("cellbismuth").next("four").next("fourornate").next("ornate").next("masonryemerald").next("emeraldcircle").next("emeraldprismatic").build(b -> b.func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE).harvestLevel(2));
    public static final Map<String, BlockEntry<BlockCarvable>> ENDSTONE = _FACTORY.newType(Material.field_151576_e, "end_stone").addTag((ITag.INamedTag<Block>)Tags.Blocks.END_STONES).addBlock(Blocks.field_196806_hJ).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(3.0f, 15.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> FACTORY = _FACTORY.newType(Material.field_151573_f, "factory").variation("dots").recipe((prov, block) -> new ShapedRecipeBuilder((IItemProvider)block, 32).func_200472_a("SXS").func_200472_a("X X").func_200472_a("SXS").func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.INGOTS_IRON).func_200465_a("has_iron", (ICriterionInstance)RegistrateRecipeProvider.hasItem((ITag<Item>)Tags.Items.INGOTS_IRON)).func_200464_a((Consumer)prov)).next("rust2").next("rust").next("platex").next("wireframewhite").next("wireframe").next("hazard").next("hazardorange").next("circuit").next("metalbox").model(ModelTemplates.cubeColumn()).next("goldplate").next("goldplating").next("grinder").next("plating").next("rustplates").next("column").model(ModelTemplates.cubeColumn()).next("frameblue").next("iceiceice").next("tilemosaic").next("vent").model(ModelTemplates.cubeColumn()).next("wireframeblue").build(b -> b.func_200947_a(ChiselSoundTypes.METAL));
    public static final Map<String, BlockEntry<BlockCarvable>> FUTURA = _FACTORY.newType(Material.field_151576_e, "futura").recipe((prov, block) -> new ShapedRecipeBuilder((IItemProvider)block, 8).func_200472_a("SSS").func_200472_a("SGS").func_200472_a("SSS").func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_redstone", (ICriterionInstance)RegistrateRecipeProvider.hasItem((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200464_a((Consumer)prov)).variation("screen_metallic").model(ModelTemplates.twoLayerTopShaded("screen_metallic", "screen_discoherent")).next("screen_cyan").model(ModelTemplates.twoLayerTopShaded("screen_cyan", "screen_discoherent")).next("controller").model(ModelTemplates.threeLayerTopShaded("controller_particle", "lines_plating", "rainbow_lines", "lines_invalid")).next("wavy").model(ModelTemplates.twoLayerTopShaded("rainbow_wave_particle", "rainbow_wave_base", "rainbow_wave")).next("controller_purple").model(ModelTemplates.threeLayerTopShaded("controller_unity_particle", "unity_lines_plating", "unity_lines", "lines_invalid")).next("uber_wavy").model(ModelTemplates.threeLayerTopShaded("orange_frame_particle", "orange_frame", "uber_rainbow", "screen_discoherent")).build();
    public static final Map<String, BlockEntry<BlockCarvable>> GLOWSTONE = _FACTORY.newType(Material.field_151592_s, "glowstone").addBlock(Blocks.field_150426_aN).loot((prov, block) -> prov.func_218507_a((Block)block, RegistrateBlockLootTables.droppingWithSilkTouch((Block)block, (LootEntry.Builder)RegistrateBlockLootTables.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)Items.field_151114_aO).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t)).func_212841_b_((ILootFunction.IBuilder)LimitCount.func_215911_a((IntClamper)IntClamper.func_215843_a((int)1, (int)4))))))).variations((Collection<VariantTemplate>)VariantTemplates.STONE).variation("extra/bismuth").localizedName("Bismuth").next("extra/tiles_large_bismuth").localizedName("Tiles Large Bismuth").next("extra/tiles_medium_bismuth").localizedName("Tiles Medium Bismuth").next("extra/neon").localizedName("Neon").next("extra/neon_panel").localizedName("Neon Panel").build(b -> b.func_200948_a(0.3f, 1.5f).func_200947_a(SoundType.field_185853_f).func_235838_a_($ -> 15));
    public static final Map<String, BlockEntry<BlockCarvable>> GRANITE = _FACTORY.newType(Material.field_151576_e, "granite").variations((Collection<VariantTemplate>)VariantTemplates.ROCK).addBlock(Blocks.field_196650_c).addBlock(Blocks.field_196652_d).build(b -> b.func_200948_a(1.5f, 30.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> LABORATORY = _FACTORY.newType(Material.field_151576_e, "laboratory").recipe((prov, block) -> new ShapedRecipeBuilder((IItemProvider)block, 8).func_200472_a("***").func_200472_a("*X*").func_200472_a("***").func_200462_a(Character.valueOf('*'), (IItemProvider)Blocks.field_150348_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151128_bU).func_200465_a("has_quartz", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)Items.field_151128_bU)).func_200464_a((Consumer)prov)).variation("wallpanel").next("dottedpanel").next("roundel").next("wallvents").model(ModelTemplates.cubeColumn()).next("largetile").next("smalltile").next("floortile").next("checkertile").next("fuzzscreen").next("largesteel").model(ModelTemplates.cubeColumn()).next("smallsteel").model(ModelTemplates.cubeColumn()).next("directionleft").model(ModelTemplates.cubeColumn()).next("directionright").model(ModelTemplates.cubeColumn()).next("infocon").model(ModelTemplates.cubeColumn()).build(b -> b.func_200947_a(ChiselSoundTypes.METAL));
    public static final Map<String, BlockEntry<BlockCarvable>> LIMESTONE = _FACTORY.newType(Material.field_151576_e, "limestone").variation(VariantTemplates.RAW).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).addTag(ChiselCompatTags.STONE_LIMESTONE).build(b -> b.func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> MARBLE = _FACTORY.newType(Material.field_151576_e, "marble").variation(VariantTemplates.RAW).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).addTag(ChiselCompatTags.STONE_MARBLE).build(b -> b.func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<WoodType, Map<String, BlockEntry<BlockCarvable>>> PLANKS = VANILLA_WOODS.stream().map(t -> Pair.of((Object)t, (Object)new ResourceLocation(t.func_227048_b_() + "_planks"))).collect(Collectors.toMap(Pair::getFirst, pair -> _FACTORY.newType(Material.field_151575_d, "planks/" + ((WoodType)pair.getFirst()).func_227048_b_()).addBlock((ResourceLocation)pair.getSecond()).setGroupName(RegistrateLangProvider.toEnglishName(((WoodType)pair.getFirst()).func_227048_b_()) + " Planks").variations((Collection<VariantTemplate>)VariantTemplates.PLANKS).build($ -> AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)ForgeRegistries.BLOCKS.getValue((ResourceLocation)pair.getSecond()))))));
    public static final Map<String, BlockEntry<BlockCarvable>> PRISMARINE = _FACTORY.newType(Material.field_151576_e, "prismarine").addBlock(Blocks.field_180397_cI).addBlock(Blocks.field_196779_gQ).addBlock(Blocks.field_196781_gR).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> PURPUR = _FACTORY.newType(Material.field_151576_e, "purpur").addBlock(Blocks.field_185767_cT).addBlock(Blocks.field_185768_cU).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> QUARTZ = _FACTORY.newType(Material.field_151576_e, "quartz").addTag((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_QUARTZ).addBlock(Blocks.field_196770_fj).addBlock(Blocks.field_196772_fk).addBlock(Blocks.field_196581_bI).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(0.8f, 4.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> RED_SANDSTONE = _FACTORY.newType(Material.field_151576_e, "red_sandstone").addBlock(Blocks.field_180395_cM).addBlock(Blocks.field_196798_hA).addBlock(Blocks.field_196799_hB).addBlock(Blocks.field_196582_bJ).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).variation("extra/bevel_skeleton").localizedName("Bevel Skeleton").next("extra/glyphs").localizedName("Glyphs").next("extra/small").localizedName("Small").build(b -> b.func_200943_b(0.8f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> REDSTONE = _FACTORY.newType(Material.field_151573_f, "redstone", BlockCreators.access$000()).addTag((ITag.INamedTag<Block>)Tags.Blocks.STORAGE_BLOCKS_REDSTONE).variations((Collection<VariantTemplate>)VariantTemplates.STONE).build(b -> b.func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_185852_e));
    public static final Map<String, BlockEntry<BlockCarvable>> SANDSTONE = _FACTORY.newType(Material.field_151576_e, "sandstone").addTag((ITag.INamedTag<Block>)Tags.Blocks.SANDSTONE).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).variation("extra/bevel_creeper").localizedName("Bevel Creeper").next("extra/glyphs").localizedName("Glyphs").next("extra/small").localizedName("Small").build(b -> b.func_200943_b(0.8f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> STONE_BRICKS = _FACTORY.newType(Material.field_151576_e, "stone_bricks").addBlock(Blocks.field_150348_b).addBlock(Blocks.field_196696_di).addBlock(Blocks.field_196702_dl).addBlock(Blocks.field_196700_dk).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).variation("extra/largeornate").localizedName("Large Ornate").next("extra/poison").localizedName("Poison").next("extra/sunken").localizedName("Sunken").build(p -> p.func_200948_a(1.5f, 10.0f));
    public static final Map<String, BlockEntry<BlockCarvable>> TERRACOTTA = _FACTORY.newType(Material.field_151576_e, "terracotta").addBlock(Blocks.field_150405_ch).variations((Collection<VariantTemplate>)VariantTemplates.ROCK).build(b -> b.func_200948_a(1.25f, 7.0f).func_200947_a(SoundType.field_185851_d));
    public static final Map<String, BlockEntry<BlockCarvable>> TYRIAN = _FACTORY.newType(Material.field_151573_f, "tyrian").variation("shining").recipe((prov, block) -> new ShapedRecipeBuilder((IItemProvider)block, 32).func_200472_a("SSS").func_200472_a("SXS").func_200472_a("SSS").func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.INGOTS_IRON).func_200465_a("has_iron", (ICriterionInstance)RegistrateRecipeProvider.hasItem((ITag<Item>)Tags.Items.INGOTS_IRON)).func_200464_a((Consumer)prov)).next("tyrian").next("chaotic").next("softplate").next("rust").next("elaborate").next("routes").next("platform").next("platetiles").next("diagonal").next("dent").next("blueplating").next("black").next("black2").next("opening").next("plate").build(b -> b.func_200947_a(SoundType.field_185852_e));
    public static final Map<DyeColor, Map<String, BlockEntry<BlockCarvable>>> WOOL = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), color -> _FACTORY.newType(Material.field_151580_n, "wool/" + color.func_176610_l()).addBlock(new ResourceLocation(color.func_176610_l() + "_wool")).setGroupName(RegistrateLangProvider.toEnglishName(color.func_176610_l()) + " Wool").variation("legacy").next("llama").build(b -> b.func_200947_a(SoundType.field_185854_g).func_200943_b(0.8f))));

    public static void init() {
    }

    private static class BlockCreators {
        private static final BlockCreator<BlockCarvable> redstoneCreator = (props, data) -> new BlockCarvable(props, data){

            @Deprecated
            public boolean func_149744_f(BlockState state) {
                return true;
            }

            @Deprecated
            public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
                return 15;
            }
        };

        private BlockCreators() {
        }

        static /* synthetic */ BlockCreator access$000() {
            return redstoneCreator;
        }
    }
}

