/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import team.chisel.client.ClientProxy;
import team.chisel.common.block.TileAutoChisel;

public class MessageUpdateAutochiselSource {
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final ItemStack stack;

    public void encode(PacketBuffer buf) {
        buf.writeLong(this.pos.func_218275_a());
        buf.func_150788_a(this.stack);
    }

    public static MessageUpdateAutochiselSource decode(PacketBuffer buf) {
        return new MessageUpdateAutochiselSource(BlockPos.func_218283_e((long)buf.readLong()), buf.func_150791_c());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te;
            World world = ClientProxy.getClientWorld();
            if (world.func_175667_e(this.pos) && (te = world.func_175625_s(this.pos)) instanceof TileAutoChisel) {
                ((TileAutoChisel)te).setSource(this.stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public MessageUpdateAutochiselSource(@Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        if (pos == null) {
            throw new NullPointerException("pos is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        this.pos = pos;
        this.stack = stack;
    }
}

