/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.data;

import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import team.chisel.api.block.ModelTemplate;
import team.chisel.repack.registrate.providers.RegistrateBlockstateProvider;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModelTemplates {
    private static String modid(Block block) {
        return block.getRegistryName().func_110624_b();
    }

    public static String name(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public static ModelTemplate simpleBlock() {
        return ModelTemplates::simpleBlock;
    }

    private static void simpleBlock(RegistrateBlockstateProvider prov, Block block) {
        prov.simpleBlock(block, (ModelFile)prov.models().cubeAll("block/" + ModelTemplates.name(block), prov.modLoc("block/" + ModelTemplates.name(block))));
    }

    public static String replaceVariant(String name, String newVariant) {
        return name.replaceAll("\\w+$", newVariant);
    }

    public static String replaceBlock(String name, String newBlock) {
        return name.replaceAll("^block/\\w+", "block/" + newBlock);
    }

    public static ModelTemplate cubeBottomTop() {
        return ModelTemplates.cubeBottomTop((String name) -> name + "-side", (String name) -> name + "-bottom", (String name) -> name + "-top");
    }

    public static ModelTemplate cubeBottomTop(String side, String bottom, String top) {
        return ModelTemplates.cubeBottomTop((String name) -> ModelTemplates.replaceVariant(name, side), (String name) -> ModelTemplates.replaceVariant(name, bottom), (String name) -> ModelTemplates.replaceVariant(name, top));
    }

    private static ModelTemplate cubeBottomTop(Function<String, String> side, Function<String, String> bottom, Function<String, String> top) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeBottomTop(name, prov.modLoc((String)side.apply(name)), prov.modLoc((String)bottom.apply(name)), prov.modLoc((String)top.apply(name))));
        };
    }

    public static ModelTemplate cubeColumn() {
        return ModelTemplates.cubeColumn((String name) -> name + "-side", (String name) -> name + "-top");
    }

    public static ModelTemplate cubeColumn(Function<String, String> top) {
        return ModelTemplates.cubeColumn((String name) -> name + "-side", top);
    }

    public static ModelTemplate cubeColumn(String side, String top) {
        return ModelTemplates.cubeColumn((String name) -> ModelTemplates.replaceVariant(name, side), (String name) -> ModelTemplates.replaceVariant(name, top));
    }

    private static ModelTemplate cubeColumn(Function<String, String> side, Function<String, String> top) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeColumn(name, prov.modLoc((String)side.apply(name)), prov.modLoc((String)top.apply(name))));
        };
    }

    public static ModelTemplate ctm(String variant) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            String texName = ModelTemplates.replaceVariant(name, variant);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("cube_ctm"))).texture("all", texName)).texture("connected_tex", texName + "-ctm"));
        };
    }

    public static ModelTemplate twoLayerWithTop(String top, boolean shade) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc(shade ? "cube_2_layer" : "cube_2_layer_no_shade"))).texture("bot", name)).texture("top", ModelTemplates.replaceVariant(name, top)));
        };
    }

    public static ModelTemplate axisFaces() {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("cube_axis"))).texture("x", name + "-ew")).texture("y", name + "-tb")).texture("z", name + "-ns"));
        };
    }

    public static ModelTemplate mossy(String base) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            String texName = ModelTemplates.replaceBlock(name, base);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("block/mossy/mossy"))).texture("bot", texName));
        };
    }

    public static ModelTemplate mossyColumn(String base) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            String texName = ModelTemplates.replaceBlock(name, base);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("block/mossy/mossy_column"))).texture("side", texName + "-side")).texture("end", texName + "-top"));
        };
    }

    public static ModelTemplate mossyCtm(String base, String variant) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            String texName = ModelTemplates.replaceBlock(name, base);
            texName = ModelTemplates.replaceVariant(texName, variant);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("block/mossy/mossy_ctm"))).texture("bot", texName)).texture("connect_bot", texName + "-ctm"));
        };
    }

    public static ModelTemplate twoLayerTopShaded(String top, String bottom) {
        return ModelTemplates.twoLayerTopShaded(top, top, bottom);
    }

    public static ModelTemplate twoLayerTopShaded(String particle, String top, String bottom) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("block/cube_2_layer_topshaded"))).texture("particle", ModelTemplates.replaceVariant(name, particle))).texture("top", ModelTemplates.replaceVariant(name, top))).texture("bot", ModelTemplates.replaceVariant(name, bottom)));
        };
    }

    public static ModelTemplate threeLayerTopShaded(String particle, String top, String mid, String bottom) {
        return (prov, block) -> {
            String name = "block/" + ModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc("block/cube_3_layer_topshaded"))).texture("particle", ModelTemplates.replaceVariant(name, particle))).texture("top", ModelTemplates.replaceVariant(name, top))).texture("mid", ModelTemplates.replaceVariant(name, mid))).texture("bot", ModelTemplates.replaceVariant(name, bottom)));
        };
    }
}

