/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.api;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.grimbo.chipped.api.BenchType;
import com.grimbo.chipped.api.ChippedBlockType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraftforge.fml.RegistryObject;

public class BlockRegistry {
    private static final Set<ChippedBlockType<Block>> BLOCKS = new HashSet<ChippedBlockType<Block>>();
    private static final SetMultimap<BenchType, String> BENCH_TAGS = LinkedHashMultimap.create();

    public static <T extends Block> void addBlock(BenchType benchType, ChippedBlockType<T> blockType, RegistryObject<T> block) {
        blockType.getBlocks().add(block);
        BLOCKS.add(blockType);
        BENCH_TAGS.put((Object)benchType, (Object)("chipped:" + blockType));
    }

    public static <T extends Block> void addGenericBlock(BenchType benchType, ChippedBlockType<Block> blockType, RegistryObject<T> block) {
        blockType.getBlocks().add(block);
        BLOCKS.add(blockType);
        BENCH_TAGS.put((Object)benchType, (Object)("chipped:" + blockType));
    }

    public static Set<String> getTags(BenchType type) {
        return BENCH_TAGS.get((Object)type);
    }

    public static Set<ChippedBlockType<Block>> getBlockTypes() {
        return BLOCKS;
    }
}

