/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.network;

import chessmod.ChessMod;
import chessmod.common.capability.elo.Elo;
import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.InvalidMoveException;
import chessmod.common.dom.model.chess.piece.Knight;
import chessmod.init.ModSounds;
import chessmod.tileentity.ChessboardTileEntity;
import chessmod.tileentity.GoldChessboardTileEntity;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChessPlay {
    private final long move;
    private final double x;
    private final double y;
    private final double z;

    public ChessPlay(long move, BlockPos pos) {
        this(move, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public ChessPlay(long move, double x, double y, double z) {
        this.move = move;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static ChessPlay decode(PacketBuffer buf) {
        long move = buf.readLong();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new ChessPlay(move, x, y, z);
    }

    public static void encode(ChessPlay msg, PacketBuffer buf) {
        buf.writeLong(msg.move);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
    }

    public static class Handler {
        public static void handle(final ChessPlay message, final Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        TileEntity tileEntity;
                        World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
                        BlockPos pos = new BlockPos(message.x, message.y, message.z);
                        if (world.isAreaLoaded(pos, 1) && (tileEntity = world.func_175625_s(pos)) instanceof ChessboardTileEntity) {
                            Board board = ((ChessboardTileEntity)tileEntity).getBoard();
                            Move m = Move.create((int)message.move, board);
                            SoundEvent sound = null;
                            sound = board.pieceAt(m.getSource()) instanceof Knight ? (board.pieceAt(m.getTarget()) == null ? ModSounds.place_piece : ModSounds.place_piece_take) : (board.pieceAt(m.getTarget()) == null ? ModSounds.slide_piece : ModSounds.slide_piece_take);
                            try {
                                if (tileEntity instanceof GoldChessboardTileEntity) {
                                    board.moveSafely(m);
                                    if (board.getCheckMate() != null) {
                                        Logger.getGlobal().info(((NetworkEvent.Context)ctx.get()).getSender().func_200200_C_().getString() + " has won a chess game with themselves!");
                                        Elo.updateElo((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), (PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), true);
                                    }
                                } else {
                                    board.move(m);
                                }
                                ((ChessboardTileEntity)tileEntity).notifyClientOfBoardChange();
                                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            }
                            catch (InvalidMoveException e) {
                                ChessMod.LOGGER.debug(e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

