/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.piece;

import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.Piece;
import java.util.HashSet;
import java.util.Set;

public class Rook
extends Piece {
    public static char WHITE_SYMBOL = (char)82;
    public static char BLACK_SYMBOL = (char)114;

    public Rook(Point position, Side side) {
        super(position, side);
    }

    @Override
    public Set<Point> getPossibleThreat(Board b) {
        HashSet<Point> possible = new HashSet<Point>();
        for (Point.Directions d : Point.Directions.PERPENDICULARS) {
            possible.addAll(b.findTargettablePointRun((Piece)this, d));
        }
        return possible;
    }

    @Override
    public char getCharacter() {
        return this.getSide().equals((Object)Side.WHITE) ? WHITE_SYMBOL : BLACK_SYMBOL;
    }

    @Override
    public int serialize() {
        int ser = this.hasMoved() ? PieceInitializer.mR.ordinal() : PieceInitializer.nmR.ordinal();
        ser <<= 1;
        return ser |= this.getSide().ordinal();
    }
}

