/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.piece;

import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.board.BoardFactory;
import chessmod.common.dom.model.chess.piece.InvalidMoveException;
import java.util.HashSet;
import java.util.Set;

public abstract class Piece {
    private Point position;
    private Side side;
    private boolean moved = false;

    public Piece(Point position, Side side) {
        this.position = position;
        this.side = side;
    }

    public boolean hasMoved() {
        return this.moved;
    }

    public void setMoved(boolean moved) {
        this.moved = moved;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Side getSide() {
        return this.side;
    }

    public Set<Move> getMovesFinalThreatNotwithstanding(Board b) throws InvalidMoveException {
        HashSet<Move> possible = new HashSet<Move>();
        if (!this.getSide().equals((Object)b.getCurrentPlayer())) {
            throw new InvalidMoveException(this + " trying to move when it is " + (Object)((Object)b.getCurrentPlayer()) + "'s turn.");
        }
        this.getPossibleThreat(b).forEach(p -> possible.add(this.createMove(b, (Point)p)));
        return possible;
    }

    public Set<Move> getAllowedMoves(Board b) throws InvalidMoveException {
        HashSet<Move> allowed = new HashSet<Move>();
        HashSet<Move> possible = new HashSet<Move>();
        possible.addAll(this.getMovesFinalThreatNotwithstanding(b));
        allowed.addAll(possible);
        for (Move m : possible) {
            Board temp = BoardFactory.createBoard(b);
            if (m instanceof Move.PawnPromotion) {
                temp.move(Move.create(m.getSource(), m.getTarget()));
            } else {
                temp.move(m);
            }
            if (!temp.isUnderThreatBy(this.getSide().other())) continue;
            allowed.remove(m);
        }
        return allowed;
    }

    public abstract Set<Point> getPossibleThreat(Board var1);

    public Move createMove(Board b, Point t) {
        return Move.create(this.getPosition(), t);
    }

    public abstract char getCharacter();

    public abstract int serialize();

    public String toString() {
        return String.format("%-6s(%s) @%s", new Object[]{this.getClass().getSimpleName(), this.side, this.getPosition()});
    }
}

