/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess.board;

import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.Piece;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;

public class SerializedBoard {
    public Long piece_mask;
    public long[] pieces;
    public long[] moves;

    public SerializedBoard(Long piece_mask, long[] pieces, long[] moves) {
        this.piece_mask = piece_mask;
        this.pieces = pieces;
        this.moves = moves;
    }

    public static SerializedBoard serialize(Board b) {
        Long myPieceMask = 0L;
        long piece = 0L;
        long moveBatch = 0L;
        LinkedList<Long> boardState = new LinkedList<Long>();
        LinkedList<Long> movesState = new LinkedList<Long>();
        int pieceCount = 0;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                if (b.pieces[y][x] == null) continue;
                ++pieceCount;
            }
        }
        int i = -(pieceCount % 16);
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                Piece p = b.pieces[y][x];
                if (p != null) {
                    myPieceMask = myPieceMask | 1L;
                    piece |= (long)p.serialize();
                    if (++i % 16 == 0) {
                        boardState.add(0, piece);
                        piece = 0L;
                    } else {
                        piece <<= 4;
                    }
                }
                if (x == 7 && y == 7) continue;
                myPieceMask = myPieceMask << 1;
            }
        }
        i = -(b.moves.size() % 4);
        for (Move m : b.moves) {
            moveBatch |= (long)m.serialize();
            if (++i % 4 == 0) {
                movesState.add(0, moveBatch);
                moveBatch = 0L;
                continue;
            }
            moveBatch <<= 16;
        }
        return new SerializedBoard(myPieceMask, ArrayUtils.toPrimitive((Long[])boardState.toArray(new Long[0])), ArrayUtils.toPrimitive((Long[])movesState.toArray(new Long[0])));
    }

    public Board deSerialize() {
        Board b = new Board();
        BitSet pieceMaskSet = BitSet.valueOf(new long[]{this.piece_mask});
        BitSet piecesSet = BitSet.valueOf(this.pieces);
        int count = pieceMaskSet.cardinality();
        int index = pieceMaskSet.nextSetBit(0);
        for (int i = 0; i < count; ++i) {
            long pieceBits = piecesSet.get(i * 4, (i + 1) * 4).toLongArray().length == 1 ? piecesSet.get(i * 4, (i + 1) * 4).toLongArray()[0] : 0L;
            Side s = Side.values()[(int)(pieceBits & 1L)];
            Point p = new Point(7 - index % 8, 7 - (index >>> 3));
            Piece piece = PieceInitializer.values()[(int)(pieceBits & 0xEL) >>> 1].create(p, s);
            b.setPiece(piece, p);
            index = pieceMaskSet.nextSetBit(index + 1);
        }
        BitSet serializedMoves = BitSet.valueOf(this.moves);
        int i = 0;
        while (serializedMoves.get(i * 16, (i + 1) * 16).toLongArray().length > 0) {
            long moveBits = serializedMoves.get(i * 16, ++i * 16).toLongArray()[0];
            Move m = Move.create((int)moveBits, b);
            b.moves.add(0, m);
        }
        return b;
    }
}

