/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess;

import chessmod.common.dom.model.chess.SpecialCase;

public class Point {
    public int x;
    public int y;
    public static final int MAX = 7;
    public static final int MIN = 0;
    public static InvalidPoint INVALID = new InvalidPoint();

    public Point n() {
        return Point.create(this, Directions.NORTH.x, Directions.NORTH.y);
    }

    public Point ne() {
        return Point.create(this, Directions.NORTH_EAST.x, Directions.NORTH_EAST.y);
    }

    public Point e() {
        return Point.create(this, Directions.EAST.x, Directions.EAST.y);
    }

    public Point se() {
        return Point.create(this, Directions.SOUTH_EAST.x, Directions.SOUTH_EAST.y);
    }

    public Point s() {
        return Point.create(this, Directions.SOUTH.x, Directions.SOUTH.y);
    }

    public Point sw() {
        return Point.create(this, Directions.SOUTH_WEST.x, Directions.SOUTH_WEST.y);
    }

    public Point w() {
        return Point.create(this, Directions.WEST.x, Directions.WEST.y);
    }

    public Point nw() {
        return Point.create(this, Directions.NORTH_WEST.x, Directions.NORTH_WEST.y);
    }

    private Point() {
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point toX(int x) {
        return Point.create(this, x, 0);
    }

    public Point toY(int y) {
        return Point.create(this, 0, y);
    }

    public static Point create(int serialized) {
        int x = serialized >>> 3 & 7;
        int y = serialized & 7;
        if (x < 0 || x > 7 || y < 0 || y > 7) {
            return INVALID;
        }
        return new Point(x, y);
    }

    public static Point create(int x, int y) {
        if (x < 0 || x > 7 || y < 0 || y > 7) {
            return INVALID;
        }
        return new Point(x, y);
    }

    public static Point create(Point p, int offsetX, int offsetY) {
        if (p.x + offsetX < 0 || p.x + offsetX > 7 || p.y + offsetY < 0 || p.y + offsetY > 7) {
            return INVALID;
        }
        return new Point(p.x + offsetX, p.y + offsetY);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object obj) {
        return obj != null && !(obj instanceof InvalidPoint) && obj.getClass() == this.getClass() && ((Point)obj).x == this.x && ((Point)obj).y == this.y;
    }

    public int hashCode() {
        return this.serialize();
    }

    public int serialize() {
        int ser = 0;
        ser |= this.x;
        ser <<= 3;
        return ser |= this.y;
    }

    @SpecialCase
    public static class InvalidPoint
    extends Point {
        @Override
        public String toString() {
            return "INVALID_POINT";
        }
    }

    public static enum Directions {
        NORTH(0, 1),
        NORTH_EAST(1, 1),
        EAST(1, 0),
        SOUTH_EAST(1, -1),
        SOUTH(0, -1),
        SOUTH_WEST(-1, -1),
        WEST(-1, 0),
        NORTH_WEST(-1, 1);

        public static Directions[] DIAGONALS;
        public static Directions[] PERPENDICULARS;
        public int x;
        public int y;

        private Directions(int x, int y) {
            this.x = x;
            this.y = y;
        }

        static {
            DIAGONALS = new Directions[]{NORTH_EAST, SOUTH_EAST, SOUTH_WEST, NORTH_WEST};
            PERPENDICULARS = new Directions[]{NORTH, EAST, SOUTH, WEST};
        }
    }
}

