/*
 * Decompiled with CFR 0.152.
 */
package chessmod.common.dom.model.chess;

import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.piece.Bishop;
import chessmod.common.dom.model.chess.piece.King;
import chessmod.common.dom.model.chess.piece.Knight;
import chessmod.common.dom.model.chess.piece.Pawn;
import chessmod.common.dom.model.chess.piece.Piece;
import chessmod.common.dom.model.chess.piece.Queen;
import chessmod.common.dom.model.chess.piece.Rook;

public enum PieceInitializer {
    P((p, s) -> new Pawn(p, s)),
    B((p, s) -> new Bishop(p, s)),
    N((p, s) -> new Knight(p, s)),
    Q((p, s) -> new Queen(p, s)),
    nmR((p, s) -> new Rook(p, s)),
    mR((p, s) -> {
        Rook r = new Rook(p, s);
        r.setMoved(true);
        return r;
    }),
    nmK((p, s) -> new King(p, s)),
    mK((p, s) -> {
        King k = new King(p, s);
        k.setMoved(true);
        return k;
    });

    PieceCreatorInterface creator;

    private PieceInitializer(PieceCreatorInterface creator) {
        this.creator = creator;
    }

    public Piece create(Point p, Side s) {
        return this.creator.create(p, s);
    }

    public static Piece create(Point target, int serialized) {
        return PieceInitializer.values()[serialized >>> 1 & 7].create(target, Side.values()[serialized & 1]);
    }

    static interface PieceCreatorInterface {
        public Piece create(Point var1, Side var2);
    }
}

