/*
 * Decompiled with CFR 0.152.
 */
package chessmod.client.gui.entity;

import chessmod.client.gui.entity.ChessboardGUI;
import chessmod.common.Point2f;
import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.piece.Piece;
import chessmod.common.network.ArbitraryPlacement;
import chessmod.common.network.PacketHandler;
import chessmod.tileentity.ChessboardTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WoodChessboardGUI
extends ChessboardGUI {
    protected ChessboardGUI.TilePiece sideBoardSelected = null;
    protected static HashMap<Integer, ChessboardGUI.TilePiece> blackSideboardMap = new HashMap();
    protected static HashMap<Integer, ChessboardGUI.TilePiece> whiteSideboardMap = new HashMap();

    public WoodChessboardGUI(ChessboardTileEntity board) {
        super(board);
        for (ChessboardGUI.TilePiece p : ChessboardGUI.TilePiece.values()) {
            if (p.getSide().equals((Object)Side.BLACK)) {
                blackSideboardMap.put(p.getIndex(), p);
                continue;
            }
            whiteSideboardMap.put(p.getIndex(), p);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawBackground();
        for (ChessboardGUI.TilePiece p : ChessboardGUI.TilePiece.values()) {
            this.drawSideboardPiece(p);
        }
        this.drawPieces();
        if (this.selected != null) {
            this.highlightSelected();
        }
        if (this.sideBoardSelected != null) {
            this.highlightSideBoardSelected();
        }
    }

    protected void highlightSideBoardSelected() {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float myHeight = Math.min(this.field_230709_l_, 256);
        float x1 = (float)this.field_230708_k_ / 2.0f - 128.0f + (float)(this.sideBoardSelected.getSide().equals((Object)Side.BLACK) ? 0 : 232);
        float x2 = x1 + 24.0f;
        float y1 = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f + (float)(32 + this.sideBoardSelected.index * 24) * myHeight / 256.0f;
        float y2 = y1 + 24.0f * myHeight / 256.0f;
        this.bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        ChessboardGUI.Color4f.POSSIBLE.draw2DRect(this.bufferbuilder, new Point2f(x1, y1), new Point2f(x2, y2));
        this.tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public boolean func_231044_a_(double x, double y, int maybeSomethingDragging) {
        boolean mouseClicked = super.func_231044_a_(x, y, maybeSomethingDragging);
        float myHeight = Math.min(this.field_230709_l_, 256);
        float boardOriginX = (float)this.field_230708_k_ / 2.0f - 128.0f;
        float boardOriginY = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f;
        float sideboardOriginY = boardOriginY + 32.0f * myHeight / 256.0f;
        double myX = x - (double)(boardOriginX + 32.0f);
        double myY = y - (double)sideboardOriginY;
        Point maybeSelected = Point.create((int)Math.floor(myX / 24.0), (int)Math.floor(myY / (double)(24.0f * myHeight / 256.0f)));
        if (maybeSelected instanceof Point.InvalidPoint || maybeSelected.equals(this.selected)) {
            if (y > (double)sideboardOriginY && y < (double)(sideboardOriginY + 144.0f)) {
                int index = (int)((y - (double)sideboardOriginY) / 24.0);
                if (x > (double)boardOriginX && x < (double)(boardOriginX + 24.0f)) {
                    this.sideBoardSelected = blackSideboardMap.get(index);
                } else if (x > (double)(boardOriginX + 16.0f + 216.0f) && x < (double)(boardOriginX + 40.0f + 216.0f)) {
                    this.sideBoardSelected = whiteSideboardMap.get(index);
                }
            } else {
                this.selected = null;
                this.sideBoardSelected = null;
            }
        } else if (this.sideBoardSelected != null) {
            this.notifyServerOfArbitraryPlacement(this.sideBoardSelected.getPieceInitializer().create(maybeSelected, this.sideBoardSelected.side));
            this.selected = null;
            this.sideBoardSelected = null;
        } else if (this.pieceAt(this.selected) != null) {
            this.notifyServerOfMove(Move.create(this.selected, maybeSelected));
            this.selected = null;
        } else {
            this.selected = maybeSelected;
            this.sideBoardSelected = null;
        }
        return mouseClicked;
    }

    protected void notifyServerOfArbitraryPlacement(Piece pi) {
        PacketHandler.sendToServer(new ArbitraryPlacement(pi, this.board.func_174877_v()));
    }
}

