/*
 * Decompiled with CFR 0.152.
 */
package chessmod.client.gui.entity;

import chessmod.ChessMod;
import chessmod.client.gui.entity.ChessboardGUI;
import chessmod.common.Point2f;
import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.InvalidMoveException;
import chessmod.common.dom.model.chess.piece.Pawn;
import chessmod.common.dom.model.chess.piece.Piece;
import chessmod.tileentity.ChessboardTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GoldChessboardGui
extends ChessboardGUI {
    Set<Move> possibleMoves = new HashSet<Move>();
    protected static HashMap<Integer, ChessboardGUI.TilePiece> blackSideboardMap = new HashMap();
    protected static HashMap<Integer, ChessboardGUI.TilePiece> whiteSideboardMap = new HashMap();
    Point promotionPosition = null;

    public GoldChessboardGui(ChessboardTileEntity board) {
        super(board);
        for (ChessboardGUI.TilePiece p : ChessboardGUI.TilePiece.values()) {
            if (p.equals((Object)ChessboardGUI.TilePiece.BLACK_PAWN) || p.equals((Object)ChessboardGUI.TilePiece.WHITE_PAWN) || p.equals((Object)ChessboardGUI.TilePiece.BLACK_KING) || p.equals((Object)ChessboardGUI.TilePiece.WHITE_KING)) continue;
            if (p.getSide().equals((Object)Side.BLACK)) {
                blackSideboardMap.put(p.getIndex(), p);
                continue;
            }
            whiteSideboardMap.put(p.getIndex(), p);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Point kingPoint;
        this.drawBackground();
        this.showTurnColor();
        this.drawPieces();
        if (this.selected != null) {
            this.highlightSelected();
        }
        this.highlightPossibleMoves();
        if (this.promotionPosition != null) {
            HashMap<Integer, ChessboardGUI.TilePiece> map = this.board.getBoard().getCurrentPlayer().equals((Object)Side.WHITE) ? whiteSideboardMap : blackSideboardMap;
            for (ChessboardGUI.TilePiece p : map.values()) {
                this.drawSideboardPiece(p);
            }
        }
        if ((kingPoint = this.board.getBoard().getCheckMate()) == null) {
            kingPoint = this.board.getBoard().getCheck();
            if (kingPoint != null) {
                this.highlightSquare(kingPoint, ChessboardGUI.Color4f.CHECK);
            }
        } else {
            this.highlightSquare(kingPoint, ChessboardGUI.Color4f.CHECKMATE);
        }
    }

    private void highlightPossibleMoves() {
        for (Move m : this.possibleMoves) {
            this.highlightSquare(m.getTarget(), ChessboardGUI.Color4f.POSSIBLE);
        }
    }

    public boolean func_231044_a_(double x, double y, int maybeSomethingDragging) {
        Point target;
        ChessboardGUI.TilePiece chosen;
        boolean mouseClicked = super.func_231044_a_(x, y, maybeSomethingDragging);
        float myHeight = Math.min(this.field_230709_l_, 256);
        float boardOriginX = (float)this.field_230708_k_ / 2.0f - 128.0f;
        float boardOriginY = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f;
        double myX = x - (double)(boardOriginX + 32.0f);
        double myY = y - (double)(boardOriginY + 32.0f);
        Point maybeSelected = Point.create((int)Math.floor(myX / 24.0), (int)Math.floor(myY / (double)(24.0f * myHeight / 256.0f)));
        Piece piece = this.pieceAt(this.selected);
        if (this.promotionPosition != null && (chosen = this.getFromSideboard(x, y)) != null && !((target = Point.create(this.promotionPosition.x, this.promotionPosition.y)) instanceof Point.InvalidPoint)) {
            this.notifyServerOfMove(Move.createPawnPromotion((Pawn)piece, target, chosen.create(target)));
            this.possibleMoves.clear();
            this.selected = null;
            this.promotionPosition = null;
        }
        Board b = this.board.getBoard();
        if (maybeSelected instanceof Point.InvalidPoint || maybeSelected.equals(this.selected)) {
            this.possibleMoves.clear();
            this.selected = null;
            this.promotionPosition = null;
        } else if (piece != null) {
            Move m = this.getMoveSelectedMove(this.selected, maybeSelected);
            if (m != null) {
                int progressionRow;
                int n = progressionRow = b.getCurrentPlayer().equals((Object)Side.BLACK) ? 0 : 7;
                if (piece instanceof Pawn && maybeSelected.y == progressionRow) {
                    this.promotionPosition = maybeSelected;
                } else {
                    this.notifyServerOfMove(m);
                    this.possibleMoves.clear();
                    this.selected = null;
                }
            }
        } else {
            Piece targetPiece = this.pieceAt(maybeSelected);
            if (targetPiece != null && targetPiece.getSide().equals((Object)b.getCurrentPlayer())) {
                this.selected = maybeSelected;
                this.possibleMoves.clear();
                try {
                    this.possibleMoves.addAll(targetPiece.getAllowedMoves(b));
                    System.out.println(targetPiece + " has moves: " + this.possibleMoves);
                }
                catch (InvalidMoveException e) {
                    ChessMod.LOGGER.debug(e.getMessage());
                    this.possibleMoves.clear();
                }
            }
        }
        return mouseClicked;
    }

    private Move getMoveSelectedMove(Point source, Point target) {
        for (Move m : this.possibleMoves) {
            if (!m.getSource().equals(source) || !m.getTarget().equals(target)) continue;
            return m;
        }
        return null;
    }

    private ChessboardGUI.TilePiece getFromSideboard(double x, double y) {
        float myHeight = Math.min(this.field_230709_l_, 256);
        float boardOriginX = (float)this.field_230708_k_ / 2.0f - 128.0f;
        float boardOriginY = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f;
        float sideboardOriginY = boardOriginY + 32.0f * myHeight / 256.0f;
        if (y > (double)sideboardOriginY && y < (double)(sideboardOriginY + 144.0f)) {
            int index = (int)((y - (double)sideboardOriginY) / 24.0);
            if (this.board.getBoard().getCurrentPlayer().equals((Object)Side.WHITE)) {
                if (x > (double)(boardOriginX + 16.0f + 216.0f) && x < (double)(boardOriginX + 40.0f + 216.0f)) {
                    return whiteSideboardMap.get(index);
                }
            } else if (x > (double)boardOriginX && x < (double)(boardOriginX + 24.0f)) {
                return blackSideboardMap.get(index);
            }
        }
        return null;
    }

    protected void showTurnColor() {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ChessboardGUI.Color4f c = ChessboardGUI.Color4f.BLACK;
        if (this.board.getBoard().getCurrentPlayer().equals((Object)Side.WHITE)) {
            c = ChessboardGUI.Color4f.WHITE;
        }
        float myHeight = Math.min(this.field_230709_l_, 256);
        float boardOriginX = (float)this.field_230708_k_ / 2.0f - 128.0f;
        float boardOriginY = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f;
        float x1Outter = boardOriginX + 26.0f;
        float x1Inner = x1Outter + 4.0f;
        float x2Inner = boardOriginX + 256.0f - 30.0f;
        float x2Outter = x2Inner + 4.0f;
        float y1Outter = boardOriginY + 26.0f * myHeight / 256.0f;
        float y1Inner = y1Outter + 4.0f * myHeight / 256.0f;
        float y2Inner = boardOriginY + myHeight - 30.0f * myHeight / 256.0f;
        float y2Outter = y2Inner + 4.0f * myHeight / 256.0f;
        this.bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Point2f p1 = new Point2f(x1Outter, y1Outter);
        Point2f p2 = new Point2f(x2Outter, y1Inner);
        c.draw2DRect(this.bufferbuilder, p1, p2);
        p2 = new Point2f(x1Inner, y2Outter);
        c.draw2DRect(this.bufferbuilder, p1, p2);
        p1 = new Point2f(x2Inner, y1Outter);
        p2 = new Point2f(x2Outter, y2Outter);
        c.draw2DRect(this.bufferbuilder, p1, p2);
        p1 = new Point2f(x1Outter, y2Inner);
        c.draw2DRect(this.bufferbuilder, p1, p2);
        this.tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

