/*
 * Decompiled with CFR 0.152.
 */
package chessmod.client.gui.entity;

import chessmod.common.Point2f;
import chessmod.common.dom.model.chess.Move;
import chessmod.common.dom.model.chess.PieceInitializer;
import chessmod.common.dom.model.chess.Point;
import chessmod.common.dom.model.chess.Side;
import chessmod.common.dom.model.chess.board.Board;
import chessmod.common.dom.model.chess.piece.Piece;
import chessmod.common.network.ChessPlay;
import chessmod.common.network.PacketHandler;
import chessmod.tileentity.ChessboardTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class ChessboardGUI
extends Screen {
    protected final ResourceLocation background;
    protected ChessboardTileEntity board;
    Tessellator tessellator = Tessellator.func_178181_a();
    BufferBuilder bufferbuilder = this.tessellator.func_178180_c();
    protected Point selected = null;
    protected static HashMap<Character, TilePiece> pieceMap = new HashMap();

    public ChessboardGUI(ChessboardTileEntity board) {
        super(null);
        this.background = new ResourceLocation("chessmod", "textures/gui/chessboard.png");
        this.board = board;
    }

    public String func_231167_h_() {
        return "";
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public boolean func_231177_au__() {
        return true;
    }

    public void func_231160_c_() {
    }

    protected Piece pieceAt(Point s) {
        if (s == null) {
            return null;
        }
        return this.board.getBoard().pieceAt(Point.create(s.x, s.y));
    }

    protected void notifyServerOfMove(Move m) {
        PacketHandler.sendToServer(new ChessPlay(m.serialize(), this.board.func_174877_v()));
    }

    protected void drawBackground() {
        this.field_230706_i_.func_110434_K().func_110577_a(this.background);
        this.bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float myHeight = Math.min(this.field_230709_l_, 256);
        float x1 = (float)this.field_230708_k_ / 2.0f - 128.0f;
        float x2 = x1 + 256.0f;
        float y1 = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f;
        float y2 = y1 + myHeight;
        this.bufferbuilder.func_225582_a_((double)x1, (double)y2, (double)this.func_230927_p_()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x2, (double)y2, (double)this.func_230927_p_()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x2, (double)y1, (double)this.func_230927_p_()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x1, (double)y1, (double)this.func_230927_p_()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        this.tessellator.func_78381_a();
    }

    protected void highlightSelected() {
        this.highlightSquare(this.selected, Color4f.SELECTED);
    }

    public void highlightSquare(Point thisselected, Color4f chosenColor) {
        float myHeight = Math.min(this.field_230709_l_, 256);
        float x1 = (float)this.field_230708_k_ / 2.0f - 128.0f + 32.0f + (float)(thisselected.x * 24);
        float x2 = x1 + 24.0f;
        float y1 = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f + (float)(32 + thisselected.y * 24) * myHeight / 256.0f;
        float y2 = y1 + 24.0f * myHeight / 256.0f;
        Point2f p1 = new Point2f(x1, y1);
        Point2f p2 = new Point2f(x2, y2);
        this.highlightSquare(p1, p2, chosenColor);
    }

    protected void highlightSquare(Point2f p1, Point2f p2, Color4f c) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        c.draw2DRect(this.bufferbuilder, p1, p2);
        this.tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void drawPiece(int bx, int by, ResourceLocation piece) {
        float myHeight = Math.min(this.field_230709_l_, 256);
        this.field_230706_i_.func_110434_K().func_110577_a(piece);
        this.bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float x1 = (float)this.field_230708_k_ / 2.0f - 128.0f + 32.0f + (float)(bx * 24);
        float x2 = x1 + 24.0f;
        float y1 = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f + (float)(32 + by * 24) * myHeight / 256.0f;
        float y2 = y1 + 24.0f * myHeight / 256.0f;
        this.bufferbuilder.func_225582_a_((double)x1, (double)y2, (double)this.func_230927_p_()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x2, (double)y2, (double)this.func_230927_p_()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x2, (double)y1, (double)this.func_230927_p_()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x1, (double)y1, (double)this.func_230927_p_()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        this.tessellator.func_78381_a();
    }

    protected void drawSideboardPiece(TilePiece piece) {
        float myHeight = Math.min(this.field_230709_l_, 256);
        this.field_230706_i_.func_110434_K().func_110577_a(piece.tile);
        float x1 = (float)this.field_230708_k_ / 2.0f - 128.0f + (float)(piece.side.equals((Object)Side.BLACK) ? 0 : 232);
        float x2 = x1 + 24.0f;
        float y1 = (float)this.field_230709_l_ / 2.0f - myHeight / 2.0f + (float)(32 + piece.index * 24) * myHeight / 256.0f;
        float y2 = y1 + 24.0f * myHeight / 256.0f;
        this.bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.bufferbuilder.func_225582_a_((double)x1, (double)y2, (double)this.func_230927_p_()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x2, (double)y2, (double)this.func_230927_p_()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x2, (double)y1, (double)this.func_230927_p_()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        this.bufferbuilder.func_225582_a_((double)x1, (double)y1, (double)this.func_230927_p_()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        this.tessellator.func_78381_a();
    }

    protected void drawPieces() {
        Board b = this.board.getBoard();
        for (int by = 0; by < 8; ++by) {
            for (int bx = 0; bx < 8; ++bx) {
                Piece piece = b.pieceAt(Point.create(bx, by));
                if (piece == null) continue;
                pieceMap.get(Character.valueOf(piece.getCharacter())).draw(this, bx, by);
            }
        }
    }

    public static class Color4f {
        float r;
        float g;
        float b;
        float a;
        public static Color4f SELECTED = new Color4f(0.5f, 0.5f, 0.8f, 0.5f);
        public static Color4f POSSIBLE = new Color4f(0.5f, 0.8f, 0.5f, 0.5f);
        public static Color4f CHECK = new Color4f(0.9f, 0.1f, 0.1f, 0.5f);
        public static Color4f CHECKMATE = new Color4f(0.9f, 0.1f, 0.1f, 0.9f);
        public static Color4f WHITE = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
        public static Color4f BLACK = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);

        public Color4f(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public void draw2DRect(BufferBuilder bufferbuilder, Point2f p1, Point2f p2) {
            bufferbuilder.func_225588_a_(p1.x, p2.y, 0.01f, this.r, this.g, this.b, this.a, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, 0.0f);
            bufferbuilder.func_225588_a_(p2.x, p2.y, 0.01f, this.r, this.g, this.b, this.a, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, 0.0f);
            bufferbuilder.func_225588_a_(p2.x, p1.y, 0.01f, this.r, this.g, this.b, this.a, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, 0.0f);
            bufferbuilder.func_225588_a_(p1.x, p1.y, 0.01f, this.r, this.g, this.b, this.a, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, 0.0f);
        }
    }

    protected static enum TilePiece {
        WHITE_KING(0, Side.WHITE, PieceInitializer.nmK, 'K', new ResourceLocation("chessmod", "textures/gui/wk.png")),
        WHITE_QUEEN(1, Side.WHITE, PieceInitializer.Q, 'Q', new ResourceLocation("chessmod", "textures/gui/wq.png")),
        WHITE_ROOK(2, Side.WHITE, PieceInitializer.nmR, 'R', new ResourceLocation("chessmod", "textures/gui/wr.png")),
        WHITE_KNIGHT(3, Side.WHITE, PieceInitializer.N, 'N', new ResourceLocation("chessmod", "textures/gui/wn.png")),
        WHITE_BISHOP(4, Side.WHITE, PieceInitializer.B, 'B', new ResourceLocation("chessmod", "textures/gui/wb.png")),
        WHITE_PAWN(5, Side.WHITE, PieceInitializer.P, 'P', new ResourceLocation("chessmod", "textures/gui/wp.png")),
        BLACK_KING(0, Side.BLACK, PieceInitializer.nmK, 'k', new ResourceLocation("chessmod", "textures/gui/bk.png")),
        BLACK_QUEEN(1, Side.BLACK, PieceInitializer.Q, 'q', new ResourceLocation("chessmod", "textures/gui/bq.png")),
        BLACK_ROOK(2, Side.BLACK, PieceInitializer.nmR, 'r', new ResourceLocation("chessmod", "textures/gui/br.png")),
        BLACK_KNIGHT(3, Side.BLACK, PieceInitializer.N, 'n', new ResourceLocation("chessmod", "textures/gui/bn.png")),
        BLACK_BISHOP(4, Side.BLACK, PieceInitializer.B, 'b', new ResourceLocation("chessmod", "textures/gui/bb.png")),
        BLACK_PAWN(5, Side.BLACK, PieceInitializer.P, 'p', new ResourceLocation("chessmod", "textures/gui/bp.png"));

        int index;
        Side side;
        char piece;
        PieceInitializer pi;
        ResourceLocation tile;

        public void draw(ChessboardGUI current, int x, int y) {
            current.drawPiece(x, y, this.tile);
        }

        public char getPiece() {
            return this.piece;
        }

        public int getIndex() {
            return this.index;
        }

        public Side getSide() {
            return this.side;
        }

        public PieceInitializer getPieceInitializer() {
            return this.pi;
        }

        public Piece create(Point p) {
            return this.pi.create(p, this.side);
        }

        public ResourceLocation getTile() {
            return this.tile;
        }

        private TilePiece(int i, Side s, PieceInitializer pi, char c, ResourceLocation tile) {
            this.index = i;
            this.side = s;
            this.pi = pi;
            this.piece = c;
            this.tile = tile;
            pieceMap.put(Character.valueOf(c), this);
        }
    }
}

