/*
 * Decompiled with CFR 0.152.
 */
package chessmod;

import chessmod.init.ModBlocks;
import chessmod.init.ModItemGroups;
import chessmod.tileentity.AIChessboardTileEntity;
import chessmod.tileentity.ChessesChessboardTileEntity;
import chessmod.tileentity.GoldChessboardTileEntity;
import chessmod.tileentity.PuzzleChessboardTileEntity;
import chessmod.tileentity.WoodChessboardTileEntity;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="chessmod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"chessmod Mod Event Subscriber");

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])new Item[0]);
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation blockRegistryName = block.getRegistryName();
            Preconditions.checkNotNull((Object)blockRegistryName, (Object)("Registry Name of Block \"" + block + "\" of class \"" + block.getClass().getName() + "\"is null! This is not allowed!"));
            if (!blockRegistryName.func_110624_b().equals("chessmod")) continue;
            Item.Properties properties = new Item.Properties().func_200916_a(ModItemGroups.MOD_ITEM_GROUP);
            BlockItem blockItem = new BlockItem(block, properties);
            registry.register((IForgeRegistryEntry)ModEventSubscriber.setup(blockItem, blockRegistryName));
        }
        LOGGER.debug("Registered Items");
    }

    @SubscribeEvent
    public static void onRegisterTileEntityTypes(@Nonnull RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{ModEventSubscriber.setup(TileEntityType.Builder.func_223042_a(WoodChessboardTileEntity::new, (Block[])new Block[]{ModBlocks.wood_chessboard}).func_206865_a(null), "wood_chessboard"), ModEventSubscriber.setup(TileEntityType.Builder.func_223042_a(GoldChessboardTileEntity::new, (Block[])new Block[]{ModBlocks.gold_chessboard}).func_206865_a(null), "gold_chessboard"), ModEventSubscriber.setup(TileEntityType.Builder.func_223042_a(ChessesChessboardTileEntity::new, (Block[])new Block[]{ModBlocks.chesses_chessboard}).func_206865_a(null), "chesses_chessboard"), ModEventSubscriber.setup(TileEntityType.Builder.func_223042_a(AIChessboardTileEntity::new, (Block[])new Block[]{ModBlocks.ai_chessboard}).func_206865_a(null), "ai_chessboard"), ModEventSubscriber.setup(TileEntityType.Builder.func_223042_a(PuzzleChessboardTileEntity::new, (Block[])new Block[]{ModBlocks.puzzle_chessboard}).func_206865_a(null), "puzzle_chessboard")});
        LOGGER.debug("Registered TileEntityTypes");
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(@Nonnull T entry, @Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name to assign to entry cannot be null!");
        return ModEventSubscriber.setup(entry, new ResourceLocation("chessmod", name));
    }

    @Nonnull
    private static <T extends IForgeRegistryEntry<T>> T setup(@Nonnull T entry, @Nonnull ResourceLocation registryName) {
        Preconditions.checkNotNull(entry, (Object)"Entry cannot be null!");
        Preconditions.checkNotNull((Object)registryName, (Object)"Registry name to assign to entry cannot be null!");
        entry.setRegistryName(registryName);
        return entry;
    }
}

