/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.mrcrayfish.furniture.client.event.CreativeScreenEvents;
import com.mrcrayfish.furniture.client.gui.screen.DoorMatScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.CrateScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.FreezerScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.MailBoxScreen;
import com.mrcrayfish.furniture.client.gui.screen.inventory.PostBoxScreen;
import com.mrcrayfish.furniture.client.renderer.SeatRenderer;
import com.mrcrayfish.furniture.client.renderer.tileentity.DoorMatTileEntityRenderer;
import com.mrcrayfish.furniture.client.renderer.tileentity.GrillTileEntityRenderer;
import com.mrcrayfish.furniture.client.renderer.tileentity.KitchenSinkTileEntityRenderer;
import com.mrcrayfish.furniture.core.ModBlocks;
import com.mrcrayfish.furniture.core.ModContainers;
import com.mrcrayfish.furniture.core.ModEntities;
import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.tileentity.DoorMatTileEntity;
import com.mrcrayfish.furniture.tileentity.TrampolineTileEntity;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientHandler {
    public static void setup() {
        ClientHandler.registerTileEntityRenderers();
        ClientHandler.registerEntityRenderers();
        ClientHandler.registerScreenFactories();
        ClientHandler.registerLayers();
        ClientHandler.registerColors();
        if (!ModList.get().isLoaded("filters")) {
            MinecraftForge.EVENT_BUS.register((Object)new CreativeScreenEvents());
        }
    }

    private static void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.GRILL.get()), GrillTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.DOOR_MAT.get()), DoorMatTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.KITCHEN_SINK.get()), KitchenSinkTileEntityRenderer::new);
    }

    private static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.SEAT.get()), SeatRenderer::new);
    }

    private static void registerScreenFactories() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.CRATE.get()), CrateScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.POST_BOX.get()), PostBoxScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.MAIL_BOX.get()), MailBoxScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FREEZER.get()), FreezerScreen::new);
    }

    private static void registerLayers() {
        Predicate<RenderType> leavesPredicate = renderType -> ClientHandler.useFancyGraphics() ? renderType == RenderType.func_228641_d_() : renderType == RenderType.func_228639_c_();
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HEDGE_OAK.get()), leavesPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HEDGE_SPRUCE.get()), leavesPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HEDGE_BIRCH.get()), leavesPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HEDGE_JUNGLE.get()), leavesPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HEDGE_ACACIA.get()), leavesPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HEDGE_DARK_OAK.get()), leavesPredicate);
        Predicate<RenderType> cutoutPredicate = renderType -> renderType == RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.TRAMPOLINE.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_WHITE.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_ORANGE.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_MAGENTA.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_LIGHT_BLUE.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_YELLOW.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_LIME.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_PINK.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_GRAY.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_LIGHT_GRAY.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_CYAN.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_PURPLE.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_BLUE.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_BROWN.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_GREEN.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_RED.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.GRILL_BLACK.get()), cutoutPredicate);
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.POST_BOX.get()), cutoutPredicate);
    }

    private static void registerColors() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> i == 1 ? -3355444 : -1, new Block[]{(Block)ModBlocks.PICKET_FENCE_WHITE.get(), (Block)ModBlocks.PICKET_FENCE_ORANGE.get(), (Block)ModBlocks.PICKET_FENCE_MAGENTA.get(), (Block)ModBlocks.PICKET_FENCE_LIGHT_BLUE.get(), (Block)ModBlocks.PICKET_FENCE_YELLOW.get(), (Block)ModBlocks.PICKET_FENCE_LIME.get(), (Block)ModBlocks.PICKET_FENCE_PINK.get(), (Block)ModBlocks.PICKET_FENCE_GRAY.get(), (Block)ModBlocks.PICKET_FENCE_LIGHT_GRAY.get(), (Block)ModBlocks.PICKET_FENCE_CYAN.get(), (Block)ModBlocks.PICKET_FENCE_PURPLE.get(), (Block)ModBlocks.PICKET_FENCE_BLUE.get(), (Block)ModBlocks.PICKET_FENCE_BROWN.get(), (Block)ModBlocks.PICKET_FENCE_GREEN.get(), (Block)ModBlocks.PICKET_FENCE_RED.get(), (Block)ModBlocks.PICKET_FENCE_BLACK.get(), (Block)ModBlocks.PICKET_GATE_WHITE.get(), (Block)ModBlocks.PICKET_GATE_ORANGE.get(), (Block)ModBlocks.PICKET_GATE_MAGENTA.get(), (Block)ModBlocks.PICKET_GATE_LIGHT_BLUE.get(), (Block)ModBlocks.PICKET_GATE_YELLOW.get(), (Block)ModBlocks.PICKET_GATE_LIME.get(), (Block)ModBlocks.PICKET_GATE_PINK.get(), (Block)ModBlocks.PICKET_GATE_GRAY.get(), (Block)ModBlocks.PICKET_GATE_LIGHT_GRAY.get(), (Block)ModBlocks.PICKET_GATE_CYAN.get(), (Block)ModBlocks.PICKET_GATE_PURPLE.get(), (Block)ModBlocks.PICKET_GATE_BLUE.get(), (Block)ModBlocks.PICKET_GATE_BROWN.get(), (Block)ModBlocks.PICKET_GATE_GREEN.get(), (Block)ModBlocks.PICKET_GATE_RED.get(), (Block)ModBlocks.PICKET_GATE_BLACK.get(), (Block)ModBlocks.POST_BOX.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, i) -> i == 1 ? 0xCCCCCC : -1, new IItemProvider[]{(IItemProvider)ModBlocks.PICKET_FENCE_WHITE.get(), (IItemProvider)ModBlocks.PICKET_FENCE_ORANGE.get(), (IItemProvider)ModBlocks.PICKET_FENCE_MAGENTA.get(), (IItemProvider)ModBlocks.PICKET_FENCE_LIGHT_BLUE.get(), (IItemProvider)ModBlocks.PICKET_FENCE_YELLOW.get(), (IItemProvider)ModBlocks.PICKET_FENCE_LIME.get(), (IItemProvider)ModBlocks.PICKET_FENCE_PINK.get(), (IItemProvider)ModBlocks.PICKET_FENCE_GRAY.get(), (IItemProvider)ModBlocks.PICKET_FENCE_LIGHT_GRAY.get(), (IItemProvider)ModBlocks.PICKET_FENCE_CYAN.get(), (IItemProvider)ModBlocks.PICKET_FENCE_PURPLE.get(), (IItemProvider)ModBlocks.PICKET_FENCE_BLUE.get(), (IItemProvider)ModBlocks.PICKET_FENCE_BROWN.get(), (IItemProvider)ModBlocks.PICKET_FENCE_GREEN.get(), (IItemProvider)ModBlocks.PICKET_FENCE_RED.get(), (IItemProvider)ModBlocks.PICKET_FENCE_BLACK.get(), (IItemProvider)ModBlocks.PICKET_GATE_WHITE.get(), (IItemProvider)ModBlocks.PICKET_GATE_ORANGE.get(), (IItemProvider)ModBlocks.PICKET_GATE_MAGENTA.get(), (IItemProvider)ModBlocks.PICKET_GATE_LIGHT_BLUE.get(), (IItemProvider)ModBlocks.PICKET_GATE_YELLOW.get(), (IItemProvider)ModBlocks.PICKET_GATE_LIME.get(), (IItemProvider)ModBlocks.PICKET_GATE_PINK.get(), (IItemProvider)ModBlocks.PICKET_GATE_GRAY.get(), (IItemProvider)ModBlocks.PICKET_GATE_LIGHT_GRAY.get(), (IItemProvider)ModBlocks.PICKET_GATE_CYAN.get(), (IItemProvider)ModBlocks.PICKET_GATE_PURPLE.get(), (IItemProvider)ModBlocks.PICKET_GATE_BLUE.get(), (IItemProvider)ModBlocks.PICKET_GATE_BROWN.get(), (IItemProvider)ModBlocks.PICKET_GATE_GREEN.get(), (IItemProvider)ModBlocks.PICKET_GATE_RED.get(), (IItemProvider)ModBlocks.PICKET_GATE_BLACK.get(), (IItemProvider)ModBlocks.POST_BOX.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> i == 1 ? 0xBBBBBB : -1, new Block[]{(Block)ModBlocks.CRATE_STRIPPED_OAK.get(), (Block)ModBlocks.CRATE_STRIPPED_SPRUCE.get(), (Block)ModBlocks.CRATE_STRIPPED_BIRCH.get(), (Block)ModBlocks.CRATE_STRIPPED_JUNGLE.get(), (Block)ModBlocks.CRATE_STRIPPED_ACACIA.get(), (Block)ModBlocks.CRATE_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.CRATE_STRIPPED_CRIMSON.get(), (Block)ModBlocks.CRATE_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_COUNTER_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_DRAWER_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_WARPED.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_SPRUCE.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_BIRCH.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_JUNGLE.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_ACACIA.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_CRIMSON.get(), (Block)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_WARPED.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, i) -> i == 1 ? 0xBBBBBB : -1, new IItemProvider[]{(IItemProvider)ModBlocks.CRATE_STRIPPED_OAK.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_SPRUCE.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_BIRCH.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_JUNGLE.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_ACACIA.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_DARK_OAK.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_CRIMSON.get(), (IItemProvider)ModBlocks.CRATE_STRIPPED_WARPED.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_SPRUCE.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_BIRCH.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_JUNGLE.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_ACACIA.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_DARK_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_CRIMSON.get(), (IItemProvider)ModBlocks.KITCHEN_COUNTER_STRIPPED_WARPED.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_SPRUCE.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_BIRCH.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_JUNGLE.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_ACACIA.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_DARK_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_CRIMSON.get(), (IItemProvider)ModBlocks.KITCHEN_DRAWER_STRIPPED_WARPED.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_SPRUCE.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_BIRCH.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_JUNGLE.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_ACACIA.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_DARK_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_CRIMSON.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_LIGHT_STRIPPED_WARPED.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_SPRUCE.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_BIRCH.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_JUNGLE.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_ACACIA.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_DARK_OAK.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_CRIMSON.get(), (IItemProvider)ModBlocks.KITCHEN_SINK_DARK_STRIPPED_WARPED.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> i == 1 ? 0x999999 : -1, new Block[]{(Block)ModBlocks.PARK_BENCH_STRIPPED_OAK.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_SPRUCE.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_BIRCH.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_JUNGLE.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_ACACIA.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_DARK_OAK.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_CRIMSON.get(), (Block)ModBlocks.PARK_BENCH_STRIPPED_WARPED.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, i) -> i == 1 ? 0x999999 : -1, new IItemProvider[]{(IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_OAK.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_SPRUCE.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_BIRCH.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_JUNGLE.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_ACACIA.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_DARK_OAK.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_CRIMSON.get(), (IItemProvider)ModBlocks.PARK_BENCH_STRIPPED_WARPED.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> i == 1 ? 0xCCCCCC : -1, new Block[]{(Block)ModBlocks.FRIDGE_LIGHT.get(), (Block)ModBlocks.FREEZER_LIGHT.get(), (Block)ModBlocks.FRIDGE_DARK.get(), (Block)ModBlocks.FREEZER_DARK.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, i) -> i == 1 ? 0xCCCCCC : -1, new IItemProvider[]{(IItemProvider)ModBlocks.FRIDGE_LIGHT.get(), (IItemProvider)ModBlocks.FREEZER_LIGHT.get(), (IItemProvider)ModBlocks.FRIDGE_DARK.get(), (IItemProvider)ModBlocks.FREEZER_DARK.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> FoliageColors.func_77466_a(), new Block[]{(Block)ModBlocks.HEDGE_SPRUCE.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> FoliageColors.func_77469_b(), new Block[]{(Block)ModBlocks.HEDGE_BIRCH.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> reader != null && pos != null ? BiomeColors.func_228361_b_((IBlockDisplayReader)reader, (BlockPos)pos) : FoliageColors.func_77468_c(), new Block[]{(Block)ModBlocks.HEDGE_OAK.get(), (Block)ModBlocks.HEDGE_JUNGLE.get(), (Block)ModBlocks.HEDGE_ACACIA.get(), (Block)ModBlocks.HEDGE_DARK_OAK.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, i) -> {
            BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, i);
        }, new IItemProvider[]{(IItemProvider)ModBlocks.HEDGE_OAK.get(), (IItemProvider)ModBlocks.HEDGE_SPRUCE.get(), (IItemProvider)ModBlocks.HEDGE_BIRCH.get(), (IItemProvider)ModBlocks.HEDGE_JUNGLE.get(), (IItemProvider)ModBlocks.HEDGE_ACACIA.get(), (IItemProvider)ModBlocks.HEDGE_DARK_OAK.get()});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, reader, pos, i) -> {
            TileEntity tileEntity;
            if (reader != null && pos != null && (tileEntity = reader.func_175625_s(pos)) instanceof TrampolineTileEntity) {
                return ((TrampolineTileEntity)tileEntity).getColour().getColorValue();
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.TRAMPOLINE.get()});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, i) -> {
            CompoundNBT blockEntityTag;
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null && (blockEntityTag = tag.func_74775_l("BlockEntityTag")).func_150297_b("Color", 3)) {
                return DyeColor.func_196056_a((int)blockEntityTag.func_74762_e("Color")).getColorValue();
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)ModBlocks.TRAMPOLINE.get()});
    }

    private static boolean useFancyGraphics() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71474_y.field_238330_f_.func_238162_a_() > 0;
    }

    public static void showDoorMatScreen(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof DoorMatTileEntity) {
            Minecraft.func_71410_x().func_147108_a((Screen)new DoorMatScreen((DoorMatTileEntity)tileEntity));
        }
    }
}

