/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ItemBlockCable
extends BlockItem {
    private String translationKey;

    public ItemBlockCable(BlockCable block, Item.Properties settings) {
        super((Block)block, settings);
    }

    boolean placeAt(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            return false;
        }
        world.func_180501_a(pos, state, 3);
        SoundType soundType = state.func_177230_c().getSoundType(state, (IWorldReader)world, pos, (Entity)player);
        world.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCable) {
            TileCable cable = (TileCable)tile;
            cable.modemChanged();
            cable.connectionsChanged();
        }
        return true;
    }

    boolean placeAtCorrected(World world, BlockPos pos, BlockState state) {
        return this.placeAt(world, pos, BlockCable.correctConnections(world, pos, state), null);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            list.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @Nonnull
    public String func_77658_a() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"block", (ResourceLocation)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this));
        }
        return this.translationKey;
    }

    public static class Cable
    extends ItemBlockCable {
        public Cable(BlockCable block, Item.Properties settings) {
            super(block, settings);
        }

        @Nonnull
        public ActionResultType func_195942_a(BlockItemUseContext context) {
            BlockPos pos;
            BlockPos insidePos;
            ItemStack stack = context.func_195996_i();
            if (stack.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            World world = context.func_195991_k();
            BlockState insideState = world.func_180495_p(insidePos = (pos = context.func_195995_a()).func_177972_a(context.func_196000_l().func_176734_d()));
            if (insideState.func_177230_c() == Registry.ModBlocks.CABLE.get() && !((Boolean)insideState.func_177229_b((Property)BlockCable.CABLE)).booleanValue() && this.placeAtCorrected(world, insidePos, (BlockState)insideState.func_206870_a((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            BlockState existingState = world.func_180495_p(pos);
            if (existingState.func_177230_c() == Registry.ModBlocks.CABLE.get() && !((Boolean)existingState.func_177229_b((Property)BlockCable.CABLE)).booleanValue() && this.placeAtCorrected(world, pos, (BlockState)existingState.func_206870_a((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            return super.func_195942_a(context);
        }
    }

    public static class WiredModem
    extends ItemBlockCable {
        public WiredModem(BlockCable block, Item.Properties settings) {
            super(block, settings);
        }

        @Nonnull
        public ActionResultType func_195942_a(BlockItemUseContext context) {
            Direction side;
            BlockState newState;
            BlockPos pos;
            ItemStack stack = context.func_195996_i();
            if (stack.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            World world = context.func_195991_k();
            BlockState existingState = world.func_180495_p(pos = context.func_195995_a());
            if (existingState.func_177230_c() == Registry.ModBlocks.CABLE.get() && existingState.func_177229_b(BlockCable.MODEM) == CableModemVariant.None && this.placeAt(world, pos, newState = (BlockState)((BlockState)existingState.func_206870_a(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.from(side = context.func_196000_l().func_176734_d())))).func_206870_a((Property)BlockCable.CONNECTIONS.get(side), existingState.func_177229_b((Property)BlockCable.CABLE)), context.func_195999_j())) {
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
            return super.func_195942_a(context);
        }
    }
}

