/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.common.ITerminal;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.InputHandler;

public interface IComputer
extends ITerminal,
InputHandler {
    public int getInstanceID();

    public boolean isOn();

    public boolean isCursorDisplayed();

    public void turnOn();

    public void shutdown();

    public void reboot();

    @Override
    public void queueEvent(String var1, Object[] var2);

    default public void queueEvent(String event) {
        this.queueEvent(event, null);
    }

    default public ComputerState getState() {
        if (!this.isOn()) {
            return ComputerState.OFF;
        }
        return this.isCursorDisplayed() ? ComputerState.BLINKING : ComputerState.ON;
    }
}

