/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.client.util.DirectBuffers;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;

public class DirectVertexBuffer
implements AutoCloseable {
    private int vertextBufferId = DirectBuffers.createBuffer();
    private int indexCount;
    private VertexFormat format;

    public void upload(int vertexCount, VertexFormat format, ByteBuffer buffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        DirectBuffers.setBufferData(34962, this.vertextBufferId, buffer, 35044);
        this.format = format;
        this.indexCount = vertexCount;
    }

    public void draw(Matrix4f matrix, int indexCount) {
        this.bind();
        this.format.func_227892_a_(0L);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)matrix);
        RenderSystem.drawArrays((int)7, (int)0, (int)indexCount);
        RenderSystem.popMatrix();
        DirectVertexBuffer.unbind();
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    @Override
    public void close() {
        if (this.vertextBufferId >= 0) {
            RenderSystem.glDeleteBuffers((int)this.vertextBufferId);
            this.vertextBufferId = -1;
        }
    }

    private void bind() {
        RenderSystem.glBindBuffer((int)34962, () -> this.vertextBufferId);
    }

    private static void unbind() {
        RenderSystem.glBindBuffer((int)34962, () -> 0);
    }
}

