/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.debug;

import cc.tweaked.internal.cobalt.Lua;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaThread;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.lib.DebugLib;

public final class DebugHelpers {
    private static final LuaString GLOBAL = ValueFactory.valueOf("global");
    private static final LuaString LOCAL = ValueFactory.valueOf("local");
    private static final LuaString METHOD = ValueFactory.valueOf("method");
    private static final LuaString UPVALUE = ValueFactory.valueOf("upvalue");
    private static final LuaString FIELD = ValueFactory.valueOf("field");
    private static final LuaString QUESTION = ValueFactory.valueOf("?");
    private static final LuaString HOOK = ValueFactory.valueOf("hook");
    private static final LuaString METAMETHOD = ValueFactory.valueOf("metamethod");
    private static final int LEVELS1 = 10;
    private static final int LEVELS2 = 11;

    private DebugHelpers() {
    }

    public static String traceback(LuaThread thread, int level) {
        return DebugHelpers.traceback(new StringBuilder(), thread, level).toString();
    }

    public static StringBuilder traceback(StringBuilder sb, LuaThread thread, int level) {
        DebugFrame di;
        int n1;
        sb.append("stack traceback:");
        DebugState state = thread.getDebugState();
        int n = n1 = state.top - level > 21 ? 10 : -1;
        while ((di = state.getFrame(level++)) != null) {
            if (n1-- == 0) {
                sb.append("\n\t...");
                level = state.top - 11 + 1;
                continue;
            }
            sb.append("\n\t");
            sb.append(di.closure == null ? "[C]" : di.closure.getPrototype().sourceShort());
            sb.append(':');
            if (di.currentLine() > 0) {
                sb.append(di.currentLine()).append(":");
            }
            sb.append(" in ");
            LuaString[] kind = di.getFuncKind();
            if (kind != null) {
                sb.append(kind[1] == GLOBAL ? "function" : kind[1]).append(" '").append(kind[0]).append('\'');
            } else if (di.closure != null && di.closure.getPrototype().linedefined == 0) {
                sb.append("main chunk");
            } else if (di.closure != null) {
                sb.append("function <").append(di.func.debugName()).append(">");
            } else {
                sb.append('?');
            }
            if ((di.flags & 0x2000) == 0) continue;
            sb.append("\n\t(...tail calls...)");
        }
        return sb;
    }

    public static String fileLine(LuaThread thread) {
        DebugState ds = thread.getDebugState();
        int n = ds.top;
        for (int i = 0; i < n; ++i) {
            DebugFrame di = ds.getFrame(i);
            if (di == null || di.closure == null) continue;
            return di.sourceLine();
        }
        return DebugHelpers.fileLine(thread, 0);
    }

    public static String fileLine(LuaThread thread, int level) {
        DebugState ds = thread.getDebugState();
        DebugFrame di = ds.getFrame(level);
        return di != null ? di.sourceLine() : null;
    }

    private static LuaString[] fromMetamethod(String name) {
        return new LuaString[]{ValueFactory.valueOf("__" + name), METAMETHOD};
    }

    public static LuaString[] getFuncName(DebugFrame di, int stackpos) {
        if (di.closure == null) {
            return null;
        }
        if ((di.flags & 4) != 0) {
            return new LuaString[]{QUESTION, HOOK};
        }
        Prototype p = di.closure.getPrototype();
        int pc = di.pc;
        int i = p.code[pc];
        switch (Lua.GET_OPCODE(i)) {
            case 28: 
            case 29: {
                return DebugHelpers.getObjectName(di, Lua.GETARG_A(i));
            }
            case 6: 
            case 11: {
                return DebugHelpers.fromMetamethod("index");
            }
            case 9: {
                return DebugHelpers.fromMetamethod("newindex");
            }
            case 12: {
                return DebugHelpers.fromMetamethod("add");
            }
            case 13: {
                return DebugHelpers.fromMetamethod("sub");
            }
            case 14: {
                return DebugHelpers.fromMetamethod("mul");
            }
            case 15: {
                return DebugHelpers.fromMetamethod("div");
            }
            case 17: {
                return DebugHelpers.fromMetamethod("pow");
            }
            case 16: {
                return DebugHelpers.fromMetamethod("mod");
            }
            case 18: {
                return DebugHelpers.fromMetamethod("unm");
            }
            case 23: {
                return DebugHelpers.fromMetamethod("eq");
            }
            case 25: {
                return DebugHelpers.fromMetamethod("le");
            }
            case 24: {
                return DebugHelpers.fromMetamethod("lt");
            }
            case 20: {
                return DebugHelpers.fromMetamethod("len");
            }
            case 21: {
                return DebugHelpers.fromMetamethod("concat");
            }
        }
        return null;
    }

    public static LuaString[] getObjectName(DebugFrame di, int stackpos) {
        int pc;
        if (di.closure == null) {
            return null;
        }
        if ((di.flags & 4) != 0) {
            return new LuaString[]{QUESTION, HOOK};
        }
        Prototype p = di.closure.getPrototype();
        LuaString name = p.getlocalname(stackpos + 1, pc = di.pc);
        if (name != null) {
            return new LuaString[]{name, LOCAL};
        }
        int i = DebugHelpers.symbexec(p, pc, stackpos);
        DebugHelpers.lua_assert(pc != -1);
        switch (Lua.GET_OPCODE(i)) {
            case 5: {
                int g = Lua.GETARG_Bx(i);
                LuaValue value = p.k[g];
                LuaString string = OperationHelper.toStringDirect(value);
                return new LuaString[]{string, GLOBAL};
            }
            case 0: {
                int a = Lua.GETARG_A(i);
                int b = Lua.GETARG_B(i);
                if (b >= a) break;
                return DebugHelpers.getObjectName(di, b);
            }
            case 6: {
                int k = Lua.GETARG_C(i);
                return new LuaString[]{DebugHelpers.constantName(p, k), FIELD};
            }
            case 4: {
                int u = Lua.GETARG_B(i);
                return new LuaString[]{u < p.upvalues.length ? p.upvalues[u] : DebugLib.QMARK, UPVALUE};
            }
            case 11: {
                int k = Lua.GETARG_C(i);
                return new LuaString[]{DebugHelpers.constantName(p, k), METHOD};
            }
        }
        return null;
    }

    private static int symbexec(Prototype pt, int lastpc, int reg) {
        int last = pt.code.length - 1;
        if (!DebugHelpers.precheck(pt)) {
            return 0;
        }
        block21: for (int pc = 0; pc < lastpc; ++pc) {
            int dest;
            int i = pt.code[pc];
            int op = Lua.GET_OPCODE(i);
            int a = Lua.GETARG_A(i);
            int b = 0;
            int c = 0;
            if (op >= 38) {
                return 0;
            }
            if (!DebugHelpers.checkRegister(pt, a)) {
                return 0;
            }
            switch (Lua.getOpMode(op)) {
                case 0: {
                    b = Lua.GETARG_B(i);
                    c = Lua.GETARG_C(i);
                    if (!DebugHelpers.checkArgMode(pt, b, Lua.getBMode(op))) {
                        return 0;
                    }
                    if (DebugHelpers.checkArgMode(pt, c, Lua.getCMode(op))) break;
                    return 0;
                }
                case 1: {
                    b = Lua.GETARG_Bx(i);
                    if (Lua.getBMode(op) != 3 || b < pt.k.length) break;
                    return 0;
                }
                case 2: {
                    int d;
                    b = Lua.GETARG_sBx(i);
                    if (Lua.getBMode(op) != 2) break;
                    dest = pc + 1 + b;
                    if (0 > dest || dest >= pt.code.length) {
                        return 0;
                    }
                    if (dest <= 0 || Lua.GET_OPCODE(d = pt.code[dest - 1]) != 34 || Lua.GETARG_C(d) != 0) break;
                    return 0;
                }
            }
            if (Lua.testAMode(op) && a == reg) {
                last = pc;
            }
            if (Lua.testTMode(op)) {
                if (pc + 2 >= pt.code.length) {
                    return 0;
                }
                if (Lua.GET_OPCODE(pt.code[pc + 1]) != 22) {
                    return 0;
                }
            }
            switch (op) {
                case 2: {
                    if (c == 0 || pc + 2 < pt.code.length) continue block21;
                    return 0;
                }
                case 3: {
                    if (a > reg || reg > b) continue block21;
                    last = pc;
                    continue block21;
                }
                case 4: 
                case 8: {
                    if (b < pt.nups) continue block21;
                    return 0;
                }
                case 5: 
                case 7: {
                    if (pt.k[b].isString()) continue block21;
                    return 0;
                }
                case 11: {
                    if (!DebugHelpers.checkRegister(pt, a + 1)) {
                        return 0;
                    }
                    if (reg != a + 1) continue block21;
                    last = pc;
                    continue block21;
                }
                case 21: {
                    if (b < c) continue block21;
                    return 0;
                }
                case 33: {
                    if (c < 1) {
                        return 0;
                    }
                    if (!DebugHelpers.checkRegister(pt, a + 2 + c)) {
                        return 0;
                    }
                    if (reg < a + 2) continue block21;
                    last = pc;
                    continue block21;
                }
                case 31: 
                case 32: {
                    if (!DebugHelpers.checkRegister(pt, a + 3)) {
                        return 0;
                    }
                }
                case 22: {
                    dest = pc + 1 + b;
                    if (reg == 255 || pc >= dest || dest > lastpc) continue block21;
                    pc += b;
                    continue block21;
                }
                case 28: 
                case 29: {
                    if (b != 0 && !DebugHelpers.checkRegister(pt, a + b - 1)) {
                        return 0;
                    }
                    if (--c == -1 ? !DebugHelpers.checkOpenUp(pt, pc) : c != 0 && !DebugHelpers.checkRegister(pt, a + c - 1)) {
                        return 0;
                    }
                    if (reg < a) continue block21;
                    last = pc;
                    continue block21;
                }
                case 30: {
                    if (--b <= 0 || DebugHelpers.checkRegister(pt, a + b - 1)) continue block21;
                    return 0;
                }
                case 34: {
                    if (b > 0 && !DebugHelpers.checkRegister(pt, a + b)) {
                        return 0;
                    }
                    if (c != 0) continue block21;
                    ++pc;
                    continue block21;
                }
                case 36: {
                    if (b >= pt.p.length) {
                        return 0;
                    }
                    int nup = pt.p[b].nups;
                    if (pc + nup >= pt.code.length) {
                        return 0;
                    }
                    for (int j = 1; j <= nup; ++j) {
                        int op1 = Lua.GET_OPCODE(pt.code[pc + j]);
                        if (op1 == 4 || op1 == 0) continue;
                        return 0;
                    }
                    if (reg == 255) continue block21;
                    pc += nup;
                    continue block21;
                }
                case 37: {
                    if ((pt.is_vararg & 2) == 0 || (pt.is_vararg & 4) != 0) {
                        return 0;
                    }
                    if (--b == -1 && !DebugHelpers.checkOpenUp(pt, pc)) {
                        return 0;
                    }
                    if (DebugHelpers.checkRegister(pt, a + b - 1)) continue block21;
                    return 0;
                }
            }
        }
        return pt.code[last];
    }

    private static boolean precheck(Prototype pt) {
        if (pt.maxstacksize > 250) {
            return false;
        }
        DebugHelpers.lua_assert(pt.numparams + (pt.is_vararg & 1) <= pt.maxstacksize);
        DebugHelpers.lua_assert((pt.is_vararg & 4) == 0 || (pt.is_vararg & 1) != 0);
        return pt.upvalues.length <= pt.nups && (pt.lineinfo.length == pt.code.length || pt.lineinfo.length == 0) && Lua.GET_OPCODE(pt.code[pt.code.length - 1]) == 30;
    }

    private static boolean checkArgMode(Prototype pt, int val, int mode) {
        switch (mode) {
            case 0: {
                if (val == 0) break;
                return false;
            }
            case 1: {
                break;
            }
            case 2: {
                DebugHelpers.checkRegister(pt, val);
                break;
            }
            case 3: {
                if (!Lua.ISK(val) ? val < pt.maxstacksize : Lua.INDEXK(val) < pt.k.length) break;
                return false;
            }
        }
        return true;
    }

    private static boolean checkRegister(Prototype proto, int reg) {
        return reg < proto.maxstacksize;
    }

    private static boolean checkOpenUp(Prototype proto, int pc) {
        int i = proto.code[pc + 1];
        switch (Lua.GET_OPCODE(i)) {
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                return Lua.GETARG_B(i) == 0;
            }
        }
        return false;
    }

    private static LuaString constantName(Prototype proto, int index) {
        if (Lua.ISK(index) && proto.k[Lua.INDEXK(index)].isString()) {
            return (LuaString)proto.k[Lua.INDEXK(index)].toLuaString();
        }
        return DebugLib.QMARK;
    }

    private static void lua_assert(boolean x) {
        if (!x) {
            throw new RuntimeException("lua_assert failed");
        }
    }
}

