/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.raytracer.DistanceRayTraceResult;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.util.PartRayTraceResult;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Objects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;

public class MultipartVoxelShape
extends VoxelShape {
    private final VoxelShape shape;
    private final TileMultiPart tile;

    public MultipartVoxelShape(VoxelShape shape, TileMultiPart tile) {
        super(shape.field_197768_g);
        this.shape = shape;
        this.tile = tile;
    }

    public DoubleList func_197757_a(Direction.Axis axis) {
        return this.shape.func_197757_a(axis);
    }

    public BlockRayTraceResult func_212433_a(Vector3d start, Vector3d end, BlockPos pos) {
        return this.tile.getPartList().stream().map(part -> {
            BlockRayTraceResult hit = part.getInteractionShape().func_212433_a(start, end, pos);
            if (hit == null) {
                hit = part.getShape(ISelectionContext.func_216377_a()).func_212433_a(start, end, pos);
            }
            if (hit == null) {
                return null;
            }
            PartRayTraceResult result = hit instanceof DistanceRayTraceResult ? new PartRayTraceResult((TMultiPart)part, (DistanceRayTraceResult)hit) : new PartRayTraceResult((TMultiPart)part, hit, start);
            result.subHit = hit.subHit;
            result.hitInfo = hit.hitInfo;
            return result;
        }).filter(Objects::nonNull).sorted().findFirst().orElse(null);
    }
}

