/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.util.CrashLock;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.network.MultiPartSPH;
import io.netty.buffer.Unpooled;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiPartLoadHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init() {
        LOCK.lock();
    }

    public static class TileNBTContainer
    extends TileEntity
    implements ITickableTileEntity {
        private int ticks;
        private boolean failed;
        private boolean loaded;
        public CompoundNBT tag;

        public TileNBTContainer() {
            super(CBMultipartModContent.tileMultipartType);
        }

        public void handleUpdateTag(BlockState state, CompoundNBT tag) {
            if (!tag.func_74764_b("data")) {
                logger.warn("Received update tag without 'data' field. Ignoring..");
                return;
            }
            byte[] data = tag.func_74770_j("data");
            TileMultiPart.handleDescPacket(this.func_145831_w(), this.func_174877_v(), (MCDataInput)new MCDataByteBuf(Unpooled.wrappedBuffer((byte[])data)));
        }

        public void func_230337_a_(BlockState state, CompoundNBT compound) {
            super.func_230337_a_(state, compound);
            if (compound != null) {
                this.tag = compound.func_74737_b();
            }
        }

        public CompoundNBT func_189515_b(CompoundNBT compound) {
            if (this.tag != null) {
                compound.func_197643_a(this.tag);
            }
            return super.func_189515_b(compound);
        }

        public void func_73660_a() {
            if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
                return;
            }
            if (!this.failed && !this.loaded) {
                if (this.tag != null) {
                    TileMultiPart newTile = TileMultiPart.fromNBT(this.tag);
                    if (newTile != null) {
                        newTile.func_145829_t();
                        this.field_145850_b.func_175690_a(this.func_174877_v(), (TileEntity)newTile);
                        newTile.notifyTileChange();
                        MultiPartSPH.sendDescUpdate(newTile);
                    } else {
                        this.field_145850_b.func_217377_a(this.func_174877_v(), false);
                    }
                    this.loaded = true;
                } else {
                    ++this.ticks;
                    if (this.ticks % 600 == 0) {
                        this.failed = true;
                        logger.warn("TileNBTContainer at '{}' still exists after {} ticks! Deleting..", (Object)this.func_174877_v(), (Object)this.ticks);
                        this.field_145850_b.func_217377_a(this.func_174877_v(), false);
                    }
                }
            }
        }
    }
}

