/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.block.BlockMultiPart;
import codechicken.multipart.block.TileMultiPart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.util.PartRayTraceResult;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class MultipartBlockRenderer
implements ICCBlockRenderer {
    public boolean canHandleBlock(IBlockDisplayReader world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() == CBMultipartModContent.blockMultipart;
    }

    public boolean renderBlock(BlockState state, BlockPos pos, IBlockDisplayReader world, MatrixStack mStack, IVertexBuilder builder, Random random, IModelData data) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)new TransformingVertexBuilder(builder, mStack), DefaultVertexFormats.field_176600_a);
            ccrs.lightMatrix.locate(world, pos);
            return this.renderStatic(tile, MinecraftForgeClient.getRenderLayer(), ccrs);
        }
        return false;
    }

    public void renderBreaking(BlockState state, BlockPos pos, IBlockDisplayReader world, MatrixStack mStack, IVertexBuilder builder, IModelData data) {
        TileMultiPart tile = BlockMultiPart.getTile((IBlockReader)world, pos);
        if (tile != null) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            mStack.func_227860_a_();
            ccrs.bind((IVertexBuilder)new TransformingVertexBuilder(builder, mStack), DefaultVertexFormats.field_176600_a);
            ccrs.overlay = OverlayTexture.field_229196_a_;
            ccrs.brightness = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos);
            ccrs.lightMatrix.locate(world, pos);
            this.renderBreaking(tile, ccrs);
            mStack.func_227865_b_();
        }
    }

    private boolean renderStatic(TileMultiPart tile, RenderType type, CCRenderState ccrs) {
        boolean ret = false;
        for (TMultiPart part : tile.getPartList()) {
            ret |= part.renderStatic(type, ccrs);
        }
        return ret;
    }

    private void renderBreaking(TileMultiPart tile, CCRenderState ccrs) {
        if (Minecraft.func_71410_x().field_71476_x instanceof PartRayTraceResult) {
            PartRayTraceResult hit = (PartRayTraceResult)Minecraft.func_71410_x().field_71476_x;
            hit.part.renderBreaking(ccrs);
        }
    }
}

