/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.IRedstoneConnectorBlock;
import codechicken.multipart.api.part.TMultiPart;
import codechicken.multipart.api.part.redstone.IFaceRedstonePart;
import codechicken.multipart.api.part.redstone.IMaskedRedstonePart;
import codechicken.multipart.api.part.redstone.IRedstonePart;
import codechicken.multipart.api.tile.IRedstoneConnector;
import codechicken.multipart.trait.extern.IRedstoneTile;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneInteractions {
    private static final Set<Block> FULL_VANILLA_BLOCKS = ImmutableSet.builder().add((Object)Blocks.field_150429_aA).add((Object)Blocks.field_196677_cy).add((Object)Blocks.field_150442_at).add((Object)Blocks.field_150430_aB).add((Object)Blocks.field_196693_eH).add((Object)Blocks.field_196697_eJ).add((Object)Blocks.field_196699_eK).add((Object)Blocks.field_196695_eI).add((Object)Blocks.field_196689_eF).add((Object)Blocks.field_196691_eG).add((Object)Blocks.field_150451_bX).add((Object)Blocks.field_150379_bu).build();

    public static int getPowerTo(TMultiPart p, int side) {
        int oc = ((IRedstoneTile)((Object)p.tile())).openConnections(side);
        return RedstoneInteractions.getPowerTo(p.world(), p.pos(), side, oc & RedstoneInteractions.connectionMask(p, side));
    }

    public static int getPowerTo(World world, BlockPos pos, int side, int mask) {
        return RedstoneInteractions.getPower(world, pos.func_177972_a(Direction.func_82600_a((int)side)), side ^ 1, mask);
    }

    public static int getPower(World world, BlockPos pos, int side, int mask) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).weakPowerLevel(side, mask);
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).weakPowerLevel((IWorldReader)world, pos, side, mask);
        }
        int vMask = RedstoneInteractions.vanillaConnectionMask((IWorldReader)world, pos, state, side, true);
        if ((vMask & mask) > 0) {
            int m = world.func_175651_c(pos, Direction.func_82600_a((int)(side ^ 1)));
            if (m < 15 && block == Blocks.field_150488_af) {
                m = Math.max(m, (Integer)state.func_177229_b((Property)RedstoneWireBlock.field_176351_O));
            }
            return m;
        }
        return 0;
    }

    public static int otherConnectionMask(IWorldReader world, BlockPos pos, int side, boolean power) {
        return RedstoneInteractions.getConnectionMask(world, pos.func_177972_a(Direction.func_82600_a((int)side)), side ^ 1, power);
    }

    public static int connectionMask(TMultiPart p, int side) {
        if (p instanceof IRedstonePart && ((IRedstonePart)((Object)p)).canConnectRedstone(side)) {
            if (p instanceof IFaceRedstonePart) {
                int fside = ((IFaceRedstonePart)((Object)p)).getFace();
                if ((side & 6) == (fside & 6)) {
                    return 16;
                }
                return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
            }
            if (p instanceof IMaskedRedstonePart) {
                return ((IMaskedRedstonePart)((Object)p)).getConnectionMask(side);
            }
            return 31;
        }
        return 0;
    }

    public static int getConnectionMask(IWorldReader world, BlockPos pos, int side, boolean power) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).getConnectionMask(side);
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IRedstoneConnectorBlock) {
            ((IRedstoneConnectorBlock)block).getConnectionMask(world, pos, side);
        }
        return RedstoneInteractions.vanillaConnectionMask(world, pos, state, side, power);
    }

    public static int vanillaConnectionMask(IWorldReader world, BlockPos pos, BlockState state, int side, boolean power) {
        Block block = state.func_177230_c();
        if (FULL_VANILLA_BLOCKS.contains(block)) {
            return 31;
        }
        if (side == 0) {
            return power ? 31 : 0;
        }
        if (block == Blocks.field_150488_af || block == Blocks.field_196762_fd) {
            if (side != 0) {
                return power ? 31 : 4;
            }
            return 0;
        }
        if (block == Blocks.field_196633_cV) {
            int fside = ((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).ordinal();
            if ((side & 6) == (fside & 6)) {
                return power ? 31 : 4;
            }
            return 0;
        }
        if (power || block.canConnectRedstone(state, (IBlockReader)world, pos, Direction.func_82600_a((int)side))) {
            return 31;
        }
        return 0;
    }
}

