/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.transformers;

import codechicken.asm.ModularASMTransformer;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.ClassNodeTransformer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class FieldWriter
extends ClassNodeTransformer {
    private static final Logger logger = LogManager.getLogger();
    public final ObfMapping field;
    public final int access;
    public final Object value;

    public FieldWriter(@Nonnull int access, @Nonnull ObfMapping field, @Nullable Object value) {
        this.field = field;
        this.access = access;
        this.value = value;
    }

    public FieldWriter(@Nonnull int access, @Nonnull ObfMapping field) {
        this(access, field, null);
    }

    @Override
    public String className() {
        return this.field.javaClass();
    }

    @Override
    public void transform(ClassNode cNode) {
        logger.log(ModularASMTransformer.LEVEL, "Writing field '{}' to class '{}'.", (Object)this.field, (Object)cNode.name);
        this.field.visitField((ClassVisitor)cNode, this.access, this.value);
    }
}

