/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.api;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.commons.Remapper;

public interface EnvironmentExtension {
    public Remapper getRemapper();

    public byte[] getClassBytes(String var1);

    public static class ExtensionLoader {
        private static final Logger logger = LogManager.getLogger();
        private static final boolean DEBUG = Boolean.getBoolean("codechicken.asm.ext.debug");
        private static final String forced = System.getProperty("codechicken.asm.ext.force");
        public static final EnvironmentExtension EXTENSION;

        static {
            if (DEBUG && forced != null) {
                logger.info("Forcing use of '{}' extension if available.", (Object)forced);
            }
            EnvironmentExtension ex = null;
            ServiceLoader<EnvironmentExtension> loader = ServiceLoader.load(EnvironmentExtension.class, Thread.currentThread().getContextClassLoader());
            Iterator<EnvironmentExtension> itr = loader.iterator();
            while (itr.hasNext()) {
                try {
                    ex = itr.next();
                    if (forced != null) {
                        if (!ex.getClass().getName().equals(forced)) continue;
                        logger.debug("Successfully forced extension class: {}", ex.getClass());
                    }
                    logger.log(DEBUG ? Level.INFO : Level.DEBUG, "Successfully loaded extension class: {}", ex.getClass());
                    break;
                }
                catch (Throwable e) {
                    if (!DEBUG) continue;
                    logger.info("Failed to load extension.", e);
                }
            }
            EXTENSION = ex;
        }
    }
}

