/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.caelus.api;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CaelusApi {
    public static final String MODID = "caelus";
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create(Attribute.class, (String)"caelus");
    public static final RegistryObject<Attribute> ELYTRA_FLIGHT = ATTRIBUTES.register("elytra_flight", () -> new RangedAttribute("caelus.elytraFlight", 0.0, 0.0, 1.0).func_233753_a_(true));
    public static final AttributeModifier ELYTRA_MODIFIER = new AttributeModifier(UUID.fromString("5b6c3728-9c24-42ae-83ac-70d61d8b8199"), "Elytra modifier", 1.0, AttributeModifier.Operation.ADDITION);
    public static final ITag.INamedTag<Item> ELYTRA = ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)new ResourceLocation("forge", "elytra"));
    public static final ITag.INamedTag<Item> ELYTRA_LIKE = ForgeTagHandler.createOptionalTag((IForgeRegistry)ForgeRegistries.ITEMS, (ResourceLocation)new ResourceLocation("forge", "elytra_like"));

    public static boolean canElytraFly(LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerEntity)) {
            ItemStack stack = livingEntity.func_184582_a(EquipmentSlotType.CHEST);
            return CaelusApi.canElytraFly(livingEntity, stack);
        }
        ModifiableAttributeInstance attribute = livingEntity.func_110148_a((Attribute)ELYTRA_FLIGHT.get());
        return attribute != null && attribute.func_111126_e() >= 1.0;
    }

    public static boolean canElytraFly(LivingEntity livingEntity, ItemStack stack) {
        return stack.canElytraFly(livingEntity) || CaelusApi.isElytraLike(stack);
    }

    public static boolean isElytra(ItemStack stack) {
        return stack.func_77973_b() instanceof ElytraItem || ELYTRA.func_230235_a_((Object)stack.func_77973_b());
    }

    public static boolean isElytraLike(ItemStack stack) {
        return ELYTRA_LIKE.func_230235_a_((Object)stack.func_77973_b());
    }
}

