/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredDiskManipulatorTileEntity;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.ProxyItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TieredDiskManipulatorNetworkNode
extends TieredNetworkNode<TieredDiskManipulatorNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
IStorageDiskContainerContext {
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_IO_MODE = "IOMode";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private int ioMode = 0;
    private final IStorageDisk<ItemStack>[] itemDisks = new IStorageDisk[6 * this.checkTierMultiplier()];
    private final IStorageDisk<FluidStack>[] fluidDisks = new IStorageDisk[6 * this.checkTierMultiplier()];
    private final UpgradeItemHandler upgrades;
    private final BaseItemHandler inputDisks;
    private final BaseItemHandler outputDisks;
    private final ProxyItemHandler disks;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.checkTierMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.checkTierMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));

    public TieredDiskManipulatorNetworkNode(World world, BlockPos pos, CableTier tier) {
        super(world, pos, ContentType.DISK_MANIPULATOR, tier);
        this.upgrades = (UpgradeItemHandler)new UpgradeItemHandler(this.getTier() == CableTier.CREATIVE ? 0 : 4, this.checkTierUpgrades()){

            public int getStackInteractCount() {
                int count = super.getStackInteractCount();
                if (TieredDiskManipulatorNetworkNode.this.type == 1) {
                    count *= 1000;
                }
                return count;
            }
        }.addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
        this.outputDisks = new BaseItemHandler(3 * this.checkTierMultiplier()).addValidator((Predicate)new StorageDiskItemValidator()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
            if (!world.field_72995_K) {
                StackUtils.createStorages((ServerWorld)((ServerWorld)world), (ItemStack)handler.getStackInSlot(slot), (int)(3 * this.checkTierMultiplier() + slot), this.itemDisks, this.fluidDisks, s -> new TieredStorageDiskItemManipulatorWrapper(this, (IStorageDisk<ItemStack>)s), s -> new TieredStorageDiskFluidManipulatorWrapper(this, (IStorageDisk<FluidStack>)s));
                if (!reading) {
                    WorldUtils.updateBlock((World)world, (BlockPos)pos);
                }
            }
        });
        this.inputDisks = new BaseItemHandler(3 * this.checkTierMultiplier()).addValidator((Predicate)new StorageDiskItemValidator()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
            if (!world.field_72995_K) {
                StackUtils.createStorages((ServerWorld)((ServerWorld)world), (ItemStack)handler.getStackInSlot(slot), (int)slot, this.itemDisks, this.fluidDisks, s -> new TieredStorageDiskItemManipulatorWrapper(this, (IStorageDisk<ItemStack>)s), s -> new TieredStorageDiskFluidManipulatorWrapper(this, (IStorageDisk<FluidStack>)s));
                if (!reading) {
                    WorldUtils.updateBlock((World)world, (BlockPos)pos);
                }
            }
        });
        this.disks = new ProxyItemHandler((IItemHandler)this.inputDisks, (IItemHandler)this.outputDisks);
    }

    private UpgradeItem.Type[] checkTierUpgrades() {
        if (this.getTier() == CableTier.ELITE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.STACK};
        }
        if (this.getTier() == CableTier.ULTRA) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED};
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return new UpgradeItem.Type[0];
        }
        return null;
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getDiskManipulator().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getDiskManipulator().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getDiskManipulator().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        int slot;
        super.update();
        if (!this.canUpdate()) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && this.ticks % this.upgrades.getSpeed() != 0) {
            return;
        }
        if (this.type == 0) {
            for (slot = 0; slot < 3 * this.checkTierMultiplier() && (this.itemDisks[slot] == null || this.isItemDiskDone(this.itemDisks[slot], slot)); ++slot) {
            }
            if (slot == 3 * this.checkTierMultiplier()) {
                return;
            }
            IStorageDisk<ItemStack> storage = this.itemDisks[slot];
            if (this.ioMode == 0) {
                this.insertItemIntoNetwork(storage);
            } else if (this.ioMode == 1) {
                this.extractItemFromNetwork(storage, slot);
            }
        } else if (this.type == 1) {
            while (slot < 3 * this.checkTierMultiplier() && (this.fluidDisks[slot] == null || this.isFluidDiskDone(this.fluidDisks[slot], slot))) {
                ++slot;
            }
            if (slot == 3 * this.checkTierMultiplier()) {
                return;
            }
            IStorageDisk<FluidStack> storage = this.fluidDisks[slot];
            if (this.ioMode == 0) {
                this.insertFluidIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFluidFromNetwork(storage, slot);
            }
        }
    }

    private void insertItemIntoNetwork(IStorageDisk<ItemStack> storage) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            ItemStack extracted = (ItemStack)storage.extract((Object)stack, this.getStackInteractCount(), this.compare, Action.PERFORM);
            if (extracted.func_190926_b()) continue;
            ItemStack remainder = this.network.insertItem(extracted, extracted.func_190916_E(), Action.PERFORM);
            if (remainder.func_190926_b()) break;
            storage.insert((Object)(extracted == remainder ? remainder.func_77946_l() : remainder), remainder.func_190916_E(), Action.PERFORM);
        }
    }

    private boolean isItemDiskDone(IStorageDisk<ItemStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack remainder;
            ItemStack stack = (ItemStack)stacks.get(i);
            ItemStack extracted = (ItemStack)storage.extract((Object)stack, this.getStackInteractCount(), this.compare, Action.SIMULATE);
            if (extracted.func_190926_b() || !(remainder = this.network.insertItem(extracted, extracted.func_190916_E(), Action.SIMULATE)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void extractItemFromNetwork(IStorageDisk<ItemStack> storage, int slot) {
        ItemStack extracted = ItemStack.field_190927_a;
        int i = 0;
        if (this.itemFilters.isEmpty()) {
            ItemStack toExtract = null;
            List networkItems = this.network.getItemStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            int j = 0;
            while ((toExtract == null || toExtract.func_190926_b()) && j < networkItems.size()) {
                toExtract = (ItemStack)networkItems.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, this.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        } else {
            while (this.itemFilters.getSlots() > i && extracted.func_190926_b()) {
                ItemStack filterStack = ItemStack.field_190927_a;
                while (this.itemFilters.getSlots() > i && filterStack.func_190926_b()) {
                    filterStack = this.itemFilters.getStackInSlot(i++);
                }
                if (filterStack.func_190926_b()) continue;
                extracted = this.network.extractItem(filterStack, this.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        }
        if (extracted.func_190926_b()) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = (ItemStack)storage.insert((Object)extracted, extracted.func_190916_E(), Action.PERFORM);
        this.network.insertItem(remainder, remainder.func_190916_E(), Action.PERFORM);
    }

    private void insertFluidIntoNetwork(IStorageDisk<FluidStack> storage, int slot) {
        ArrayList stacks = new ArrayList(storage.getStacks());
        FluidStack extracted = FluidStack.EMPTY;
        int i = 0;
        while (extracted.isEmpty() && stacks.size() > i) {
            FluidStack stack = (FluidStack)stacks.get(i++);
            extracted = (FluidStack)storage.extract((Object)stack, this.getStackInteractCount(), this.compare, Action.PERFORM);
        }
        if (extracted.isEmpty()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = this.network.insertFluid(extracted, extracted.getAmount(), Action.PERFORM);
        storage.insert((Object)remainder, remainder.getAmount(), Action.PERFORM);
    }

    private boolean isFluidDiskDone(IStorageDisk<FluidStack> storage, int slot) {
        if (this.ioMode == 0 && storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return true;
        }
        if (this.ioMode == 1) {
            if (storage.getStored() == storage.getCapacity()) {
                this.moveDriveToOutput(slot);
                return true;
            }
            return false;
        }
        ArrayList stacks = new ArrayList(storage.getStacks());
        for (int i = 0; i < stacks.size(); ++i) {
            FluidStack remainder;
            FluidStack stack = (FluidStack)stacks.get(i);
            FluidStack extracted = (FluidStack)storage.extract((Object)stack, this.getStackInteractCount(), this.compare, Action.SIMULATE);
            if (extracted.isEmpty() || !(remainder = this.network.insertFluid(extracted, extracted.getAmount(), Action.SIMULATE)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void extractFluidFromNetwork(IStorageDisk<FluidStack> storage, int slot) {
        FluidStack extracted = FluidStack.EMPTY;
        int i = 0;
        if (this.fluidFilters.isEmpty()) {
            FluidStack toExtract = null;
            List networkFluids = this.network.getFluidStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            int j = 0;
            while ((toExtract == null || toExtract.getAmount() == 0) && j < networkFluids.size()) {
                toExtract = (FluidStack)networkFluids.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        } else {
            while (this.fluidFilters.getSlots() > i && extracted.isEmpty()) {
                FluidStack filterStack = FluidStack.EMPTY;
                while (this.fluidFilters.getSlots() > i && filterStack.isEmpty()) {
                    filterStack = this.fluidFilters.getFluid(i++);
                }
                if (filterStack.isEmpty()) continue;
                extracted = this.network.extractFluid(filterStack, this.getStackInteractCount(), this.compare, Action.PERFORM);
            }
        }
        if (extracted.isEmpty()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = (FluidStack)storage.insert((Object)extracted, extracted.getAmount(), Action.PERFORM);
        this.network.insertFluid(remainder, remainder.getAmount(), Action.PERFORM);
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.inputDisks.getStackInSlot(slot);
        if (!disk.func_190926_b()) {
            int i;
            for (i = 0; i < 3 * this.checkTierMultiplier() && !this.outputDisks.getStackInSlot(i).func_190926_b(); ++i) {
            }
            if (i == 3 * this.checkTierMultiplier()) {
                return;
            }
            this.inputDisks.extractItem(slot, 1, false);
            this.outputDisks.insertItem(i, disk, false);
        }
    }

    private int getStackInteractCount() {
        if (this.getTier() == CableTier.CREATIVE) {
            return Integer.MAX_VALUE;
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 64 * (Integer)CableConfig.ULTRA_DISK_MANIPULATOR_SPEED.get();
        }
        if (this.getTier() == CableTier.ELITE) {
            return this.upgrades.getStackInteractCount() * (Integer)CableConfig.ELITE_DISK_MANIPULATOR_SPEED.get();
        }
        return 0;
    }

    private int checkTierMultiplier() {
        if (this.getTier() == CableTier.ELITE) {
            return 2;
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 3;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4;
        }
        return 0;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TieredDiskManipulatorTileEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public int getIoMode() {
        return this.ioMode;
    }

    public void setIoMode(int ioMode) {
        this.ioMode = ioMode;
    }

    public IItemHandler getInputDisks() {
        return this.inputDisks;
    }

    public IItemHandler getOutputDisks() {
        return this.outputDisks;
    }

    public ProxyItemHandler getDisks() {
        return this.disks;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)3, (CompoundNBT)tag);
        StackUtils.readItems((BaseItemHandler)this.inputDisks, (int)4, (CompoundNBT)tag);
        StackUtils.readItems((BaseItemHandler)this.outputDisks, (int)5, (CompoundNBT)tag);
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)3, (CompoundNBT)tag);
        StackUtils.writeItems((IItemHandler)this.inputDisks, (int)4, (CompoundNBT)tag);
        StackUtils.writeItems((IItemHandler)this.outputDisks, (int)5, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)1, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74768_a(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)1, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_IO_MODE)) {
            this.ioMode = tag.func_74762_e(NBT_IO_MODE);
        }
    }

    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDisks, this.outputDisks, this.upgrades});
    }

    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }

    public class TieredStorageDiskItemManipulatorWrapper
    implements IStorageDisk<ItemStack> {
        private final TieredDiskManipulatorNetworkNode diskManipulator;
        private final IStorageDisk<ItemStack> parent;
        private DiskState lastState;

        public TieredStorageDiskItemManipulatorWrapper(TieredDiskManipulatorNetworkNode diskManipulator, IStorageDisk<ItemStack> parent) {
            this.diskManipulator = diskManipulator;
            this.parent = parent;
            this.setSettings(() -> {
                DiskState currentState = DiskState.get((int)this.getStored(), (int)this.getCapacity());
                if (this.lastState != currentState) {
                    this.lastState = currentState;
                    WorldUtils.updateBlock((World)diskManipulator.getWorld(), (BlockPos)diskManipulator.getPos());
                }
            }, diskManipulator);
            this.lastState = DiskState.get((int)this.getStored(), (int)this.getCapacity());
        }

        public int getCapacity() {
            return this.parent.getCapacity();
        }

        @Nullable
        public UUID getOwner() {
            return this.parent.getOwner();
        }

        public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
            this.parent.setSettings(listener, context);
        }

        public CompoundNBT writeToNbt() {
            return this.parent.writeToNbt();
        }

        public Collection<ItemStack> getStacks() {
            return this.parent.getStacks();
        }

        @Nonnull
        public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
            if (stack.func_190926_b()) {
                return stack;
            }
            if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.diskManipulator.getItemFilters(), (int)this.diskManipulator.getWhitelistBlacklistMode(), (int)this.diskManipulator.getCompare(), (ItemStack)stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return (ItemStack)this.parent.insert((Object)stack, size, action);
        }

        @Nonnull
        public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
            if (!IWhitelistBlacklist.acceptsItem((IItemHandler)this.diskManipulator.getItemFilters(), (int)this.diskManipulator.getWhitelistBlacklistMode(), (int)this.diskManipulator.getCompare(), (ItemStack)stack)) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)this.parent.extract((Object)stack, size, flags, action);
        }

        public int getStored() {
            return this.parent.getStored();
        }

        public int getPriority() {
            return this.parent.getPriority();
        }

        public AccessType getAccessType() {
            return this.parent.getAccessType();
        }

        public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
            return this.parent.getCacheDelta(storedPreInsertion, size, (Object)remainder);
        }

        public ResourceLocation getFactoryId() {
            return this.parent.getFactoryId();
        }
    }

    public class TieredStorageDiskFluidManipulatorWrapper
    implements IStorageDisk<FluidStack> {
        private final TieredDiskManipulatorNetworkNode diskManipulator;
        private final IStorageDisk<FluidStack> parent;
        private DiskState lastState;

        public TieredStorageDiskFluidManipulatorWrapper(TieredDiskManipulatorNetworkNode diskManipulator, IStorageDisk<FluidStack> parent) {
            this.diskManipulator = diskManipulator;
            this.parent = parent;
            this.setSettings(() -> {
                DiskState currentState = DiskState.get((int)this.getStored(), (int)this.getCapacity());
                if (this.lastState != currentState) {
                    this.lastState = currentState;
                    WorldUtils.updateBlock((World)diskManipulator.getWorld(), (BlockPos)diskManipulator.getPos());
                }
            }, diskManipulator);
            this.lastState = DiskState.get((int)this.getStored(), (int)this.getCapacity());
        }

        public int getCapacity() {
            return this.parent.getCapacity();
        }

        @Nullable
        public UUID getOwner() {
            return this.parent.getOwner();
        }

        public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
            this.parent.setSettings(listener, context);
        }

        public CompoundNBT writeToNbt() {
            return this.parent.writeToNbt();
        }

        public ResourceLocation getFactoryId() {
            return this.parent.getFactoryId();
        }

        public Collection<FluidStack> getStacks() {
            return this.parent.getStacks();
        }

        @Nonnull
        public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
            if (stack.isEmpty()) {
                return stack;
            }
            if (!IWhitelistBlacklist.acceptsFluid((FluidInventory)this.diskManipulator.getFluidFilters(), (int)this.diskManipulator.getWhitelistBlacklistMode(), (int)this.diskManipulator.getCompare(), (FluidStack)stack)) {
                return StackUtils.copy((FluidStack)stack, (int)size);
            }
            return (FluidStack)this.parent.insert((Object)stack, size, action);
        }

        @Nonnull
        public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
            if (!IWhitelistBlacklist.acceptsFluid((FluidInventory)this.diskManipulator.getFluidFilters(), (int)this.diskManipulator.getWhitelistBlacklistMode(), (int)this.diskManipulator.getCompare(), (FluidStack)stack)) {
                return FluidStack.EMPTY;
            }
            return (FluidStack)this.parent.extract((Object)stack, size, flags, action);
        }

        public int getStored() {
            return this.parent.getStored();
        }

        public int getPriority() {
            return this.parent.getPriority();
        }

        public AccessType getAccessType() {
            return this.parent.getAccessType();
        }

        public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
            return this.parent.getCacheDelta(storedPreInsertion, size, (Object)remainder);
        }
    }
}

