/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredImporterTileEntity;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.DiskDriveTile;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredImporterNetworkNode
extends TieredNetworkNode<TieredImporterNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 9;
    private static final int SPEED_INCREASE = 2;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades;
    private int compare;
    private int mode;
    private int type;
    private int currentSlot;
    private final CoverManager coverManager;

    public TieredImporterNetworkNode(World world, BlockPos pos, CableTier tier) {
        super(world, pos, ContentType.IMPORTER, tier);
        UpgradeItem.Type[] typeArray;
        int n = this.getTier() == CableTier.CREATIVE ? 0 : 4;
        if (this.getTier() == CableTier.ELITE) {
            UpgradeItem.Type[] typeArray2 = new UpgradeItem.Type[2];
            typeArray2[0] = UpgradeItem.Type.SPEED;
            typeArray = typeArray2;
            typeArray2[1] = UpgradeItem.Type.STACK;
        } else {
            UpgradeItem.Type[] typeArray3 = new UpgradeItem.Type[1];
            typeArray = typeArray3;
            typeArray3[0] = UpgradeItem.Type.SPEED;
        }
        this.upgrades = (UpgradeItemHandler)new UpgradeItemHandler(n, typeArray).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
        this.compare = 1;
        this.mode = 1;
        this.type = 0;
        this.coverManager = new CoverManager((NetworkNode)this);
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getImporter().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        int baseSpeed;
        int speed;
        super.update();
        if (!(this.canUpdate() && this.world.func_195588_v(this.pos) && this.world.func_195588_v(this.pos.func_177972_a(this.getDirection())))) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && (speed = Math.max(1, this.upgrades.getSpeed(baseSpeed = 9 / this.getSpeedMultiplier(), 2))) > 1 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            this.itemUpdate();
        } else if (this.type == 1) {
            this.fluidUpdate();
        }
    }

    private int getSpeedMultiplier() {
        switch (this.getTier()) {
            case ELITE: {
                return (Integer)CableConfig.ELITE_IMPORTER_SPEED.get();
            }
            case ULTRA: {
                return (Integer)CableConfig.ULTRA_IMPORTER_SPEED.get();
            }
        }
        throw new RuntimeException("illegal tier " + (Object)((Object)this.getTier()));
    }

    private boolean interactWithStacks() {
        return this.getTier() != CableTier.ELITE || this.upgrades.hasUpgrade(UpgradeItem.Type.STACK);
    }

    private void itemUpdate() {
        TileEntity facing = this.getFacingTile();
        if (facing == null || facing instanceof DiskDriveTile) {
            return;
        }
        IItemHandler handler = WorldUtils.getItemHandler((TileEntity)facing, (Direction)this.getDirection().func_176734_d());
        if (handler == null || handler.getSlots() <= 0) {
            return;
        }
        if (this.currentSlot >= handler.getSlots()) {
            this.currentSlot = 0;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            while (this.doItemExtraction(handler)) {
            }
        } else {
            this.doItemExtraction(handler);
        }
    }

    private boolean doItemExtraction(IItemHandler handler) {
        int startSlot = this.currentSlot;
        do {
            int interactionCount;
            ItemStack result;
            ItemStack stack = handler.getStackInSlot(this.currentSlot);
            if (this.network.getItemStorageCache().getList().getCount((Object)stack) == Integer.MAX_VALUE) {
                return false;
            }
            if (!stack.func_190926_b() && IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)stack) && !(result = handler.extractItem(this.currentSlot, interactionCount = this.interactWithStacks() ? stack.func_190916_E() : 1, true)).func_190926_b()) {
                int remaining = this.network.insertItem(result, result.func_190916_E(), Action.SIMULATE).func_190916_E();
                int inserted = result.func_190916_E() - remaining;
                if (inserted > 0) {
                    result = handler.extractItem(this.currentSlot, inserted, false);
                    this.network.insertItemTracked(result, result.func_190916_E());
                    return true;
                }
            }
            if (++this.currentSlot < handler.getSlots()) continue;
            this.currentSlot = 0;
        } while (this.currentSlot != startSlot);
        return false;
    }

    private void fluidUpdate() {
        IFluidHandler handler = WorldUtils.getFluidHandler((TileEntity)this.getFacingTile(), (Direction)this.getDirection().func_176734_d());
        TileEntity facing = this.getFacingTile();
        if (facing == null) {
            return;
        }
        if (handler == null) {
            return;
        }
        if (this.currentSlot >= handler.getTanks()) {
            this.currentSlot = 0;
        }
        if (this.getTier() == CableTier.CREATIVE) {
            while (this.doFluidExtraction(handler)) {
            }
        } else {
            this.doFluidExtraction(handler);
        }
    }

    private boolean doFluidExtraction(IFluidHandler handler) {
        int startSlot = this.currentSlot;
        if (handler.getTanks() != 0) {
            do {
                FluidStack stack = handler.getFluidInTank(this.currentSlot);
                if (this.network.getFluidStorageCache().getList().getCount((Object)stack) == Integer.MAX_VALUE) {
                    return false;
                }
                if (!stack.isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)stack)) {
                    int interactionAmount = this.interactWithStacks() ? (this.getTier() == CableTier.CREATIVE ? stack.getAmount() : 64000) : 1000;
                    FluidStack toExtract = stack.copy();
                    toExtract.setAmount(interactionAmount);
                    FluidStack result = handler.drain(toExtract, IFluidHandler.FluidAction.SIMULATE);
                    if (!result.isEmpty()) {
                        int remaining = this.network.insertFluid(result, result.getAmount(), Action.SIMULATE).getAmount();
                        int inserted = result.getAmount() - remaining;
                        if (inserted > 0) {
                            toExtract = stack.copy();
                            toExtract.setAmount(inserted);
                            result = handler.drain(toExtract, IFluidHandler.FluidAction.EXECUTE);
                            FluidStack actualRemainder = this.network.insertFluidTracked(result, result.getAmount());
                            if (!actualRemainder.isEmpty()) {
                                result.shrink(actualRemainder.getAmount());
                            }
                            return true;
                        }
                    }
                }
                if (++this.currentSlot < handler.getTanks()) continue;
                this.currentSlot = 0;
            } while (this.currentSlot != startSlot);
            return false;
        }
        return false;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.upgrades;
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TieredImporterTileEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

