/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.node;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.config.CableConfig;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredDestructorTileEntity;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TieredDestructorNetworkNode
extends TieredNetworkNode<TieredDestructorNetworkNode>
implements IComparable,
IWhitelistBlacklist,
IType,
ICoverable {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_PICKUP = "Pickup";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int BASE_SPEED = 20;
    private static final int SPEED_INCREASE = 4;
    private final BaseItemHandler itemFilters = new BaseItemHandler(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(9 * this.getTier().getSlotsMultiplier()).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, this.checkTierUpgrades()).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        this.tool = this.createTool();
    });
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private boolean pickupItem = false;
    private ItemStack tool = this.createTool();
    private CoverManager coverManager = new CoverManager((NetworkNode)this);

    public TieredDestructorNetworkNode(World world, BlockPos pos, CableTier tier) {
        super(world, pos, ContentType.DESTRUCTOR, tier);
    }

    private UpgradeItem.Type[] checkTierUpgrades() {
        if (this.getTier() == CableTier.CREATIVE) {
            return new UpgradeItem.Type[]{UpgradeItem.Type.SILK_TOUCH, UpgradeItem.Type.FORTUNE_1, UpgradeItem.Type.FORTUNE_2, UpgradeItem.Type.FORTUNE_3};
        }
        return new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.SILK_TOUCH, UpgradeItem.Type.FORTUNE_1, UpgradeItem.Type.FORTUNE_2, UpgradeItem.Type.FORTUNE_3};
    }

    public int getEnergyUsage() {
        if (this.getTier() == CableTier.ELITE) {
            return 4 * (RS.SERVER_CONFIG.getDestructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ELITE_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.ULTRA) {
            return 4 * (RS.SERVER_CONFIG.getDestructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.ULTRA_ENERGY_COST.get();
        }
        if (this.getTier() == CableTier.CREATIVE) {
            return 4 * (RS.SERVER_CONFIG.getDestructor().getUsage() + this.upgrades.getEnergyUsage()) * (Integer)CableConfig.CREATIVE_ENERGY_COST.get();
        }
        return 0;
    }

    public void update() {
        int baseSpeed;
        int speed;
        super.update();
        if (!(this.canUpdate() && this.world.func_195588_v(this.pos) && this.world.func_195588_v(this.pos.func_177972_a(this.getDirection())))) {
            return;
        }
        if (this.getTier() != CableTier.CREATIVE && (speed = Math.max(1, this.upgrades.getSpeed(baseSpeed = 20 / this.getSpeedMultiplier(), 4))) > 1 && this.ticks % speed != 0) {
            return;
        }
        if (this.type == 0) {
            if (this.pickupItem) {
                this.pickupItems();
            } else {
                this.breakBlock();
            }
        } else if (this.type == 1) {
            this.breakFluid();
        }
    }

    private int getSpeedMultiplier() {
        switch (this.getTier()) {
            case ELITE: {
                return (Integer)CableConfig.ELITE_DESTRUCTOR_SPEED.get();
            }
            case ULTRA: {
                return (Integer)CableConfig.ULTRA_DESTRUCTOR_SPEED.get();
            }
        }
        throw new RuntimeException("illegal tier " + (Object)((Object)this.getTier()));
    }

    private void pickupItems() {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        ArrayList droppedItems = new ArrayList();
        this.world.func_175726_f(front).func_177430_a(ItemEntity.class, new AxisAlignedBB(front), droppedItems, EntityPredicates.field_94557_a);
        for (ItemEntity entity : droppedItems) {
            ItemStack droppedItem = entity.func_92059_d();
            if (droppedItem.func_190926_b() || !IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)droppedItem)) continue;
            ItemStack remaining = this.network.insertItemTracked(droppedItem.func_77946_l(), droppedItem.func_190916_E());
            int inserted = droppedItem.func_190916_E() - remaining.func_190916_E();
            if (inserted <= 0) continue;
            if (remaining.func_190926_b()) {
                entity.func_70106_y();
            } else {
                entity.func_92058_a(remaining);
            }
            if (this.getTier() == CableTier.CREATIVE) continue;
            break;
        }
    }

    private void breakBlock() {
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        BlockState frontBlockState = this.world.func_180495_p(front);
        if (frontBlockState.func_185887_b((IBlockReader)this.world, front) < 0.0f) {
            return;
        }
        Block frontBlock = frontBlockState.func_177230_c();
        FakePlayer fakePlayer = WorldUtils.getFakePlayer((ServerWorld)((ServerWorld)this.world), (UUID)this.getOwner());
        ItemStack frontStack = frontBlock.getPickBlock(frontBlockState, (RayTraceResult)new BlockRayTraceResult(Vector3d.field_186680_a, this.getDirection().func_176734_d(), front, false), (IBlockReader)this.world, front, (PlayerEntity)fakePlayer);
        if (frontStack.func_190926_b() || !IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, (int)this.mode, (int)this.compare, (ItemStack)frontStack)) {
            return;
        }
        List drops = Block.func_220077_a((BlockState)frontBlockState, (ServerWorld)((ServerWorld)this.world), (BlockPos)front, (TileEntity)this.world.func_175625_s(front), (Entity)fakePlayer, (ItemStack)this.tool);
        for (ItemStack drop : drops) {
            if (this.network.insertItem(drop, drop.func_190916_E(), Action.SIMULATE).func_190926_b()) continue;
            return;
        }
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(this.world, front, frontBlockState, (PlayerEntity)fakePlayer);
        if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
            frontBlock.func_176208_a(this.world, front, frontBlockState, (PlayerEntity)fakePlayer);
            this.world.func_217377_a(front, false);
            for (ItemStack drop : drops) {
                if (this.network == null) {
                    InventoryHelper.func_180173_a((World)this.world, (double)((double)front.func_177958_n() + 0.5), (double)((double)front.func_177956_o() + 0.5), (double)((double)front.func_177952_p() + 0.5), (ItemStack)drop);
                    continue;
                }
                ItemStack itemStack = this.network.insertItemTracked(drop, drop.func_190916_E());
            }
        }
    }

    private void breakFluid() {
        FluidStack result;
        IFluidBlock fluidBlock;
        BlockPos front = this.pos.func_177972_a(this.getDirection());
        BlockState frontBlockState = this.world.func_180495_p(front);
        Block frontBlock = frontBlockState.func_177230_c();
        if (frontBlock instanceof IFluidBlock && (fluidBlock = (IFluidBlock)frontBlock).canDrain(this.world, front) && !(result = fluidBlock.drain(this.world, front, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)result) && this.network.insertFluid(result, result.getAmount(), Action.SIMULATE).isEmpty()) {
            result = fluidBlock.drain(this.world, front, IFluidHandler.FluidAction.EXECUTE);
            FluidStack remainder = this.network.insertFluidTracked(result, result.getAmount());
            return;
        }
        if (frontBlock instanceof IBucketPickupHandler) {
            FluidStack result2;
            IBucketPickupHandler bucketPickupHandler = (IBucketPickupHandler)frontBlock;
            FluidState fluidState = this.world.func_204610_c(front);
            if (!fluidState.func_206888_e() && !(result2 = new FluidStack(fluidState.func_206886_c(), 1000)).isEmpty() && IWhitelistBlacklist.acceptsFluid((FluidInventory)this.fluidFilters, (int)this.mode, (int)this.compare, (FluidStack)result2) && this.network.insertFluid(result2, result2.getAmount(), Action.SIMULATE).isEmpty()) {
                result2 = new FluidStack(bucketPickupHandler.func_204508_a((IWorld)this.world, front, frontBlockState), 1000);
                FluidStack remainder = this.network.insertFluidTracked(result2, result2.getAmount());
                return;
            }
        }
    }

    private ItemStack createTool() {
        ItemStack newTool = new ItemStack((IItemProvider)(this.getTier() == CableTier.CREATIVE ? Items.field_234756_kK_ : Items.field_151046_w));
        if (this.upgrades.hasUpgrade(UpgradeItem.Type.SILK_TOUCH)) {
            newTool.func_77966_a(Enchantments.field_185306_r, 1);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_3)) {
            newTool.func_77966_a(Enchantments.field_185308_t, 3);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_2)) {
            newTool.func_77966_a(Enchantments.field_185308_t, 2);
        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.FORTUNE_1)) {
            newTool.func_77966_a(Enchantments.field_185308_t, 1);
        }
        return newTool;
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        if (tag.func_74764_b(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.func_74775_l(CoverManager.NBT_COVER_MANAGER));
        }
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        tag.func_218657_a(CoverManager.NBT_COVER_MANAGER, (INBT)this.coverManager.writeToNbt());
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_PICKUP, this.pickupItem);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_PICKUP)) {
            this.pickupItem = tag.func_74767_n(NBT_PICKUP);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TieredDestructorTileEntity.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public boolean isPickupItem() {
        return this.pickupItem;
    }

    public void setPickupItem(boolean pickupItem) {
        this.pickupItem = pickupItem;
    }

    public CoverManager getCoverManager() {
        return this.coverManager;
    }
}

