/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CableTiers.blocks;

import com.YTrollman.CableTiers.CableTier;
import com.YTrollman.CableTiers.ContentType;
import com.YTrollman.CableTiers.node.TieredNetworkNode;
import com.YTrollman.CableTiers.tileentity.TieredTileEntity;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.container.factory.PositionalTileContainerProvider;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.CollisionUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class TieredCableBlock<T extends TieredTileEntity<N>, N extends TieredNetworkNode<N>>
extends CableBlock {
    private final ContentType<? extends TieredCableBlock<T, N>, T, ?, N> contentType;
    private final CableTier tier;

    protected TieredCableBlock(ContentType<? extends TieredCableBlock<T, N>, T, ?, N> contentType, CableTier tier) {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.contentType = contentType;
        this.tier = tier;
    }

    public ContentType<? extends TieredCableBlock<T, N>, T, ?, N> getContentType() {
        return this.contentType;
    }

    public CableTier getTier() {
        return this.tier;
    }

    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    protected abstract VoxelShape getHeadShape(BlockState var1);

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return ConstantsCable.addCoverVoxelShapes((VoxelShape)ShapeCache.getOrCreate((BlockState)state, s -> {
            VoxelShape shape = TieredCableBlock.getCableShape((BlockState)s);
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)this.getHeadShape((BlockState)s));
            return shape;
        }), (IBlockReader)world, (BlockPos)pos);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.contentType.getTileEntityType(this.tier).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K && CollisionUtils.isInBounds((VoxelShape)this.getHeadShape(state), (BlockPos)pos, (Vector3d)hit.func_216347_e())) {
            return NetworkUtils.attemptModify((World)world, (BlockPos)pos, (PlayerEntity)player, () -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new PositionalTileContainerProvider((ITextComponent)new TranslationTextComponent(this.func_149739_a()), (tile, windowId, inventory, p) -> this.contentType.createContainer(windowId, p, (TieredTileEntity)((Object)((Object)tile))), pos), (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }
}

