/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.mushrooms.util;

import corgiaoc.byg.common.world.feature.config.BYGMushroomConfig;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public abstract class BYGHugeMushroom {
    @Nullable
    protected abstract ConfiguredFeature<BYGMushroomConfig, ?> getHugeMushroomFeature(Random var1);

    public boolean withSpawner(ISeedReader worldIn, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random) {
        ConfiguredFeature<BYGMushroomConfig, ?> abstractMushroomFeature = this.getHugeMushroomFeature(random);
        if (abstractMushroomFeature == null) {
            return false;
        }
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
        ((BYGMushroomConfig)abstractMushroomFeature.field_222738_b).forcePlacement();
        if (abstractMushroomFeature.func_242765_a(worldIn, chunkGenerator, random, pos)) {
            return true;
        }
        worldIn.func_180501_a(pos, blockUnder, 4);
        return false;
    }

    public static abstract class Massive
    extends BYGHugeMushroom {
        public static boolean canMassiveMushroomSpawnAt(BlockState blockUnder, IBlockReader worldIn, BlockPos pos, int xOffset, int zOffset) {
            Block block = blockUnder.func_177230_c();
            return block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset + 1)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset + 1)).func_177230_c();
        }

        @Override
        public boolean withSpawner(ISeedReader worldIn, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random) {
            for (int i = 0; i >= -1; --i) {
                for (int j = 0; j >= -1; --j) {
                    if (!Massive.canMassiveMushroomSpawnAt(blockUnder, (IBlockReader)worldIn, pos, i, j)) continue;
                    return this.massiveMushroom(worldIn, chunkGenerator, pos, blockUnder, random, i, j);
                }
            }
            return super.withSpawner(worldIn, chunkGenerator, pos, blockUnder, random);
        }

        @Nullable
        protected abstract ConfiguredFeature<BYGMushroomConfig, ?> getMassiveMushroomFeature(Random var1);

        public boolean massiveMushroom(ISeedReader worldIn, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random, int xOffset, int zOffset) {
            ConfiguredFeature<BYGMushroomConfig, ?> abstractMushroomFeature = this.getMassiveMushroomFeature(random);
            if (abstractMushroomFeature == null) {
                return false;
            }
            BlockState blockstate = Blocks.field_150350_a.func_176223_P();
            worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockstate, 4);
            worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockstate, 4);
            worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockstate, 4);
            worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockstate, 4);
            ((BYGMushroomConfig)abstractMushroomFeature.field_222738_b).forcePlacement();
            if (abstractMushroomFeature.func_242765_a(worldIn, chunkGenerator, random, pos.func_177982_a(xOffset, 0, zOffset))) {
                return true;
            }
            worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockUnder, 4);
            worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockUnder, 4);
            worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockUnder, 4);
            worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockUnder, 4);
            return false;
        }
    }
}

