/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.biome;

import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.biomedata.BiomeData;
import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.mixin.access.BiomeAccess;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;

public class BYGEndSubBiome {
    public static final List<BYGEndSubBiome> BYG_END_SUB_BIOMES = new ArrayList<BYGEndSubBiome>();
    private final Biome biome;
    public static List<BiomeData> biomeData = new ArrayList<BiomeData>();
    public static List<BiomeData> voidSubBiomeData = new ArrayList<BiomeData>();

    public BYGEndSubBiome(Biome.Climate climate, Biome.Category category, float depth, float scale, BiomeAmbience effects, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.biome = BiomeAccess.create(climate, category, depth, scale, effects, biomeGenerationSettings, mobSpawnInfo);
        BYG_END_SUB_BIOMES.add(this);
    }

    public BYGEndSubBiome(Biome.Builder builder) {
        this.biome = builder.func_242455_a();
        BYG_END_SUB_BIOMES.add(this);
    }

    public BYGEndSubBiome(Biome biome) {
        this.biome = biome;
        BYG_END_SUB_BIOMES.add(this);
    }

    public Biome getBiome() {
        return this.biome;
    }

    @Nullable
    public Biome getEdge() {
        return null;
    }

    public String[] getBiomeDictionary() {
        return new String[]{"END"};
    }

    public RegistryKey<Biome> getKey() {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(WorldGenRegistries.field_243657_i.func_177774_c((Object)this.biome)));
    }

    public static BiomeDataHolders.EndSubBiomeDataHolder extractDefaultHolder(Registry<Biome> biomeRegistry) {
        HashMap<ResourceLocation, BiomeData> biomeData = new HashMap<ResourceLocation, BiomeData>();
        HashMap<ResourceLocation, BiomeData> voidBiomeData = new HashMap<ResourceLocation, BiomeData>();
        for (BYGEndSubBiome bygBiome : BYG_END_SUB_BIOMES) {
            List<String> dictionary = Arrays.asList(bygBiome.getBiomeDictionary());
            boolean isVoid = new HashSet<String>(dictionary).contains("VOID");
            BiomeData endBiomeData = new BiomeData(dictionary, bygBiome.getEdge() != null ? biomeRegistry.func_177774_c((Object)bygBiome.getEdge()) : new ResourceLocation(""));
            ResourceLocation key = biomeRegistry.func_177774_c((Object)bygBiome.getBiome());
            if (key != null) {
                if (!isVoid) {
                    biomeData.put(key, endBiomeData);
                    continue;
                }
                voidBiomeData.put(key, endBiomeData);
                continue;
            }
            BYG.LOGGER.warn(bygBiome.getClass().getSimpleName() + " is not registered...");
        }
        return new BiomeDataHolders.EndSubBiomeDataHolder(biomeData, voidBiomeData);
    }
}

