/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.util.compression.DataCompressor;
import com.direwolf20.buildinggadgets.common.util.compression.DataDecompressor;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public final class Undo {
    private RegistryKey<World> dim;
    private Map<BlockPos, BlockInfo> dataMap;
    private Region boundingBox;

    static Undo deserialize(CompoundNBT nbt) {
        Preconditions.checkArgument((nbt.func_150297_b("dim", 8) && nbt.func_150297_b("items_serializer_list", 9) && nbt.func_150297_b("block_list", 9) && nbt.func_150297_b("data_list", 9) && nbt.func_150297_b("data_serializer_list", 9) ? 1 : 0) != 0);
        DataDecompressor<ITileDataSerializer> serializerReverseObjectIncrementer = new DataDecompressor<ITileDataSerializer>((ListNBT)nbt.func_74781_a("data_serializer_list"), inbt -> {
            String s = inbt.func_150285_a_();
            ITileDataSerializer serializer = RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), s);
            if (serializer == null) {
                BuildingGadgets.LOG.warn("Found unknown serializer {}. Replacing with dummy!", (Object)s);
                serializer = TileSupport.dummyTileEntityData().getSerializer();
            }
            return serializer;
        }, value -> {
            BuildingGadgets.LOG.warn("Attempted to query unknown serializer {}. Replacing with dummy!", (Object)value);
            return TileSupport.dummyTileEntityData().getSerializer();
        });
        DataDecompressor<BlockData> dataReverseObjectIncrementer = new DataDecompressor<BlockData>((ListNBT)nbt.func_74781_a("data_list"), inbt -> BlockData.deserialize((CompoundNBT)inbt, serializerReverseObjectIncrementer, true), value -> BlockData.AIR);
        DataDecompressor<IUniqueObjectSerializer> itemSerializerIncrementer = new DataDecompressor<IUniqueObjectSerializer>((ListNBT)nbt.func_74781_a("items_serializer_list"), inbt -> {
            String s = inbt.func_150285_a_();
            IUniqueObjectSerializer serializer = RegistryUtils.getFromString(Registries.getUniqueObjectSerializers(), s);
            if (serializer == null) {
                return SerialisationSupport.uniqueItemSerializer();
            }
            return serializer;
        }, value -> {
            BuildingGadgets.LOG.warn("Attempted to query unknown item-serializer {}. Replacing with default!", (Object)value);
            return SerialisationSupport.uniqueItemSerializer();
        });
        DataDecompressor<Multiset> itemSetReverseObjectIncrementer = new DataDecompressor<Multiset>((ListNBT)nbt.func_74781_a("items_list"), inbt -> NBTHelper.deserializeMultisetEntries((ListNBT)inbt, HashMultiset.create(), entry -> Undo.readEntry(entry, itemSerializerIncrementer)), value -> HashMultiset.create());
        Map<BlockPos, BlockInfo> map = NBTHelper.deserializeMap((ListNBT)nbt.func_74781_a("block_list"), new HashMap(), inbt -> NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)inbt)), inbt -> BlockInfo.deserialize((CompoundNBT)inbt, dataReverseObjectIncrementer, itemSetReverseObjectIncrementer));
        RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim")));
        Region bounds = Region.deserializeFrom(nbt.func_74775_l("bounding_box"));
        return new Undo((RegistryKey<World>)dim, map, bounds);
    }

    private static Tuple<IUniqueObject<?>, Integer> readEntry(INBT inbt, IntFunction<IUniqueObjectSerializer> serializerIntFunction) {
        CompoundNBT nbt = (CompoundNBT)inbt;
        IUniqueObjectSerializer serializer = serializerIntFunction.apply(nbt.func_74762_e("serializer"));
        int count = nbt.func_74762_e("count");
        IUniqueObject<?> item = serializer.deserialize(nbt.func_74775_l("item"));
        return new Tuple(item, (Object)count);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Undo(RegistryKey<World> dim, Map<BlockPos, BlockInfo> dataMap, Region boundingBox) {
        this.dim = dim;
        this.dataMap = dataMap;
        this.boundingBox = boundingBox;
    }

    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public Map<BlockPos, BlockInfo> getUndoData() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    CompoundNBT serialize() {
        DataCompressor<BlockData> dataObjectIncrementer = new DataCompressor<BlockData>();
        DataCompressor<IUniqueObjectSerializer> itemSerializerIncrementer = new DataCompressor<IUniqueObjectSerializer>();
        DataCompressor<Multiset> itemObjectIncrementer = new DataCompressor<Multiset>();
        DataCompressor<ITileDataSerializer> serializerObjectIncrementer = new DataCompressor<ITileDataSerializer>();
        CompoundNBT res = new CompoundNBT();
        ListNBT infoList = NBTHelper.serializeMap(this.dataMap, NBTUtil::func_186859_a, i -> ((BlockInfo)i).serialize(dataObjectIncrementer, itemObjectIncrementer));
        ListNBT dataList = dataObjectIncrementer.write(d -> d.serialize(serializerObjectIncrementer, true));
        ListNBT itemSetList = itemObjectIncrementer.write(ms -> NBTHelper.writeIterable(ms.entrySet(), entry -> this.writeEntry((Multiset.Entry<IUniqueObject<?>>)entry, itemSerializerIncrementer)));
        ListNBT dataSerializerList = serializerObjectIncrementer.write(ts -> StringNBT.func_229705_a_((String)ts.getRegistryName().toString()));
        ListNBT itemSerializerList = itemSerializerIncrementer.write(s -> StringNBT.func_229705_a_((String)s.getRegistryName().toString()));
        res.func_74778_a("dim", this.dim.getRegistryName().toString());
        res.func_218657_a("block_list", (INBT)infoList);
        res.func_218657_a("data_list", (INBT)dataList);
        res.func_218657_a("data_serializer_list", (INBT)dataSerializerList);
        res.func_218657_a("items_list", (INBT)itemSetList);
        res.func_218657_a("items_serializer_list", (INBT)itemSerializerList);
        res.func_218657_a("bounding_box", (INBT)this.boundingBox.serialize());
        return res;
    }

    private CompoundNBT writeEntry(Multiset.Entry<IUniqueObject<?>> entry, ToIntFunction<IUniqueObjectSerializer> serializerObjectIncrementer) {
        CompoundNBT res = new CompoundNBT();
        res.func_74768_a("serializer", serializerObjectIncrementer.applyAsInt(((IUniqueObject)entry.getElement()).getSerializer()));
        res.func_218657_a("item", (INBT)((IUniqueObject)entry.getElement()).getSerializer().serialize((IUniqueObject)entry.getElement(), true));
        res.func_74768_a("count", entry.getCount());
        return res;
    }

    public static final class Builder {
        private final ImmutableMap.Builder<BlockPos, BlockInfo> mapBuilder = ImmutableMap.builder();
        private Region.Builder regionBuilder = null;

        private Builder() {
        }

        public Builder record(IBlockReader reader, BlockPos pos, BlockData placeData, Multiset<IUniqueObject<?>> requiredItems, Multiset<IUniqueObject<?>> producedItems) {
            BlockState state = reader.func_180495_p(pos);
            TileEntity te = reader.func_175625_s(pos);
            ITileEntityData data = te != null ? NBTTileEntityData.ofTile(te) : TileSupport.dummyTileEntityData();
            return this.record(pos, new BlockData(state, data), placeData, requiredItems, producedItems);
        }

        private Builder record(BlockPos pos, BlockData recordedData, BlockData placedData, Multiset<IUniqueObject<?>> requiredItems, Multiset<IUniqueObject<?>> producedItems) {
            this.mapBuilder.put((Object)pos, (Object)new BlockInfo(recordedData, placedData, requiredItems, producedItems));
            if (this.regionBuilder == null) {
                this.regionBuilder = Region.enclosingBuilder();
            }
            this.regionBuilder.enclose((Vector3i)pos);
            return this;
        }

        public Undo build(World dim) {
            return new Undo((RegistryKey<World>)dim.func_234923_W_(), (Map<BlockPos, BlockInfo>)this.mapBuilder.build(), this.regionBuilder != null ? this.regionBuilder.build() : Region.singleZero());
        }
    }

    public static final class BlockInfo {
        private final BlockData recordedData;
        private final BlockData placedData;
        private final Multiset<IUniqueObject<?>> usedItems;
        private final Multiset<IUniqueObject<?>> producedItems;

        private static BlockInfo deserialize(CompoundNBT nbt, IntFunction<BlockData> dataSupplier, IntFunction<Multiset<IUniqueObject<?>>> itemSetSupplier) {
            BlockData data = dataSupplier.apply(nbt.func_74762_e("recorded_data"));
            BlockData placedData = dataSupplier.apply(nbt.func_74762_e("placed_data"));
            Multiset<IUniqueObject<?>> usedItems = itemSetSupplier.apply(nbt.func_74762_e("used_items"));
            Multiset<IUniqueObject<?>> producedItems = itemSetSupplier.apply(nbt.func_74762_e("produced_items"));
            return new BlockInfo(data, placedData, usedItems, producedItems);
        }

        private BlockInfo(BlockData recordedData, BlockData placedData, Multiset<IUniqueObject<?>> usedItems, Multiset<IUniqueObject<?>> producedItems) {
            this.recordedData = recordedData;
            this.placedData = placedData;
            this.usedItems = usedItems;
            this.producedItems = producedItems;
        }

        private CompoundNBT serialize(ToIntFunction<BlockData> dataIdSupplier, ToIntFunction<Multiset<IUniqueObject<?>>> itemIdSupplier) {
            CompoundNBT res = new CompoundNBT();
            res.func_74768_a("recorded_data", dataIdSupplier.applyAsInt(this.recordedData));
            res.func_74768_a("placed_data", dataIdSupplier.applyAsInt(this.placedData));
            res.func_74768_a("used_items", itemIdSupplier.applyAsInt(this.usedItems));
            res.func_74768_a("produced_items", itemIdSupplier.applyAsInt(this.producedItems));
            return res;
        }

        public BlockData getRecordedData() {
            return this.recordedData;
        }

        public BlockData getPlacedData() {
            return this.placedData;
        }

        public Multiset<IUniqueObject<?>> getUsedItems() {
            return Multisets.unmodifiableMultiset(this.usedItems);
        }

        public Multiset<IUniqueObject<?>> getProducedItems() {
            return Multisets.unmodifiableMultiset(this.producedItems);
        }
    }
}

