/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSetRemoteInventoryCache {
    private final boolean isCopyPaste;
    private Multiset<UniqueItem> cache;
    private Pair<BlockPos, RegistryKey<World>> loc;

    public PacketSetRemoteInventoryCache(Multiset<UniqueItem> cache, boolean isCopyPaste) {
        this.cache = cache;
        this.isCopyPaste = isCopyPaste;
    }

    public PacketSetRemoteInventoryCache(Pair<BlockPos, RegistryKey<World>> loc, boolean isCopyPaste) {
        this.loc = loc;
        this.isCopyPaste = isCopyPaste;
    }

    public static PacketSetRemoteInventoryCache decode(PacketBuffer buf) {
        boolean isCopyPaste = buf.readBoolean();
        if (buf.readBoolean()) {
            ImmutablePair loc = new ImmutablePair((Object)buf.func_179259_c(), (Object)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l()));
            return new PacketSetRemoteInventoryCache((Pair<BlockPos, RegistryKey<World>>)loc, isCopyPaste);
        }
        int len = buf.readInt();
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (int i = 0; i < len; ++i) {
            builder.addCopies((Object)new UniqueItem(Item.func_150899_d((int)buf.readInt())), buf.readInt());
        }
        ImmutableMultiset cache = builder.build();
        return new PacketSetRemoteInventoryCache((Multiset<UniqueItem>)cache, isCopyPaste);
    }

    public static void encode(PacketSetRemoteInventoryCache msg, PacketBuffer buf) {
        buf.writeBoolean(msg.isCopyPaste());
        boolean isRequest = msg.getCache() == null;
        buf.writeBoolean(isRequest);
        if (isRequest) {
            buf.writeLong(((BlockPos)msg.getLoc().getLeft()).func_218275_a());
            buf.func_192572_a(((RegistryKey)msg.getLoc().getRight()).func_240901_a_());
            return;
        }
        Set items = msg.getCache().entrySet();
        buf.writeInt(items.size());
        for (Multiset.Entry entry : items) {
            UniqueItem uniqueItem = (UniqueItem)entry.getElement();
            buf.writeInt(Item.func_150891_b((Item)uniqueItem.createStack().func_77973_b()));
            buf.writeInt(entry.getCount());
        }
    }

    public boolean isCopyPaste() {
        return this.isCopyPaste;
    }

    public Multiset<UniqueItem> getCache() {
        return this.cache;
    }

    public Pair<BlockPos, RegistryKey<World>> getLoc() {
        return this.loc;
    }

    public static class Handler {
        public static void handle(PacketSetRemoteInventoryCache msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    HashSet itemTypes = new HashSet();
                    ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                    InventoryLinker.getLinkedInventory(player.field_70170_p, (BlockPos)msg.loc.getKey(), (RegistryKey<World>)((RegistryKey)msg.loc.getValue()), null).ifPresent(inventory -> {
                        for (int i = 0; i < inventory.getSlots(); ++i) {
                            Item item;
                            UniqueItem uniqueItem;
                            ItemStack stack = inventory.getStackInSlot(i);
                            if (stack.func_190926_b() || itemTypes.contains(uniqueItem = new UniqueItem(item = stack.func_77973_b()))) continue;
                            itemTypes.add(uniqueItem);
                            builder.addCopies((Object)uniqueItem, InventoryHelper.countInContainer(inventory, item));
                        }
                    });
                    PacketHandler.sendTo(new PacketSetRemoteInventoryCache((Multiset<UniqueItem>)builder.build(), msg.isCopyPaste()), player);
                    return;
                }
                if (msg.isCopyPaste()) {
                    EventTooltip.setCache(msg.getCache());
                } else {
                    BaseRenderer.setInventoryCache(msg.getCache());
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

