/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.containers;

import com.direwolf20.buildinggadgets.common.containers.BaseContainer;
import com.direwolf20.buildinggadgets.common.containers.OurContainers;
import com.direwolf20.buildinggadgets.common.tileentities.TemplateManagerTileEntity;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TemplateManagerContainer
extends BaseContainer {
    public static final String TEXTURE_LOC_SLOT_TOOL = "buildinggadgets:gui/slot_copy_paste_gadget";
    public static final String TEXTURE_LOC_SLOT_TEMPLATE = "buildinggadgets:gui/slot_template";
    private TemplateManagerTileEntity te;

    public TemplateManagerContainer(int windowId, PlayerInventory playerInventory, PacketBuffer extraData) {
        super((ContainerType)OurContainers.TEMPLATE_MANAGER_CONTAINER.get(), windowId);
        BlockPos pos = extraData.func_179259_c();
        this.te = (TemplateManagerTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory, -12, 70);
    }

    public TemplateManagerContainer(int windowId, PlayerInventory playerInventory, TemplateManagerTileEntity tileEntity) {
        super((ContainerType)OurContainers.TEMPLATE_MANAGER_CONTAINER.get(), windowId);
        this.te = Objects.requireNonNull(tileEntity);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory, -12, 70);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.getTe().canInteractWith(playerIn);
    }

    private void addOwnSlots() {
        IItemHandler itemHandler = (IItemHandler)this.getTe().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(CapabilityNotPresentException::new);
        int x = 132;
        this.func_75146_a((Slot)new SlotTemplateManager(itemHandler, 0, x, 18, TEXTURE_LOC_SLOT_TOOL));
        this.func_75146_a((Slot)new SlotTemplateManager(itemHandler, 1, x, 63, TEXTURE_LOC_SLOT_TEMPLATE));
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack currentStack = slot.func_75211_c();
            itemstack = currentStack.func_77946_l();
            if (index < 2 ? !this.func_75135_a(currentStack, 2, this.field_75151_b.size(), true) : !this.func_75135_a(currentStack, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (currentStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public TemplateManagerTileEntity getTe() {
        return this.te;
    }

    public static class SlotTemplateManager
    extends SlotItemHandler {
        private String backgroundLoc;

        public SlotTemplateManager(IItemHandler itemHandler, int index, int xPosition, int yPosition, String backgroundLoc) {
            super(itemHandler, index, xPosition, yPosition);
            this.backgroundLoc = backgroundLoc;
        }

        public Slot setBackground(ResourceLocation atlas, ResourceLocation sprite) {
            return super.setBackground(atlas, new ResourceLocation("buildinggadgets", this.backgroundLoc));
        }

        public int func_75219_a() {
            return 1;
        }
    }
}

